/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.label;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.SWT;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;

/**
 * @author Tuukka Lehtonen
 */
public class ConnectionRelationLabelDecorationRule implements LabelDecorationRule {

    public static final ConnectionRelationLabelDecorationRule INSTANCE = new ConnectionRelationLabelDecorationRule();

    static LabelDecorator DECO = new LabelDecorator.Stub() {
        @SuppressWarnings("unchecked")
        public <F> F decorateFont(F font, String column, int itemIndex) {
            return (F) ((FontDescriptor) font).withStyle(SWT.BOLD); 
        }
    };

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        Resource cr = (Resource) content;
        DiagramResource DIA = DiagramResource.getInstance(graph);
        ModelingResources MOD = ModelingResources.getInstance(graph);

        for (Resource dcr : graph.getObjects(cr, MOD.ConnectionRelationToDiagramConnectionRelation)) {
            for (Resource terminal : graph.getObjects(dcr, DIA.HasConnectionPoint_Inverse)) {
                if (graph.isInstanceOf(terminal, DIA.Terminal))
                    return DECO;
            }
        }

        return null;
    }

}
