/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.Collection;
import java.util.Collections;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.common.node.IDeletable;
import org.simantics.browsing.ui.common.node.IModifiable;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.graph.impl.LabelerUtil;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.RelatedValue;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.Activator;

/**
 * 
 * @author J-P Laine
 *
 * @Deprecated Use org.simantics.image instead
 */
@Deprecated
public class Image extends Node implements IAdaptable, IDeletable, IModifiable {

    public Image(Resource image) {
        super(image);
    }

    @Override
    public String getLabel(ReadGraph g) throws DatabaseException {
        String name = LabelerUtil.safeStringRepresentation(g, resource);
        return name;
    }

    @Override
    public Collection<?> getChildren(ReadGraph g) {
        return Collections.emptyList();
    }

    @Override
    public ImageDescriptor getImage(ReadGraph g) {
        return Activator.IMAGE_ICON;
    }

    @Override
    public Modifier getModifier(final Session session, String columnId) {
        return new Modifier() {

            @Override
            public String getValue() {
                // TODO: rename the workspace directory containing the data
                try {
                	Layer0 b = Layer0.getInstance(session);
                    return session.syncRequest(new RelatedValue<String>(resource, b.HasName, Bindings.STRING));
                } catch (DatabaseException e) {
                    e.printStackTrace();
                    return "";
                }
            }

            @Override
            public String isValid(String label) {
                return null;
            }

            @Override
            public void modify(final String label) {
                session.asyncRequest(new WriteRequest() {

                    @Override
                    public void perform(WriteGraph g) throws DatabaseException {
                    	Layer0 b = Layer0.getInstance(g);
                        g.claimLiteral(resource, b.HasName, label);
                    }

                });
            }

        };
    }
}
