/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.node.DeleteException;
import org.simantics.browsing.ui.common.node.IModifiable;
import org.simantics.browsing.ui.common.node.IRefreshable;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.browsing.ui.graph.impl.LabelerUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentResource;
import org.simantics.modeling.ui.Activator;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.ui.ErrorLogger;

@Deprecated
public class Experiment extends Node implements INode2, IPathNode, IRefreshable, IModifiable, IDisposable {

    private static final String PENDING = "pending...";

    private static final Supplier<Boolean> DEFAULT_IS_DISPOSED = () -> false;

    Supplier<Boolean> isDisposed = DEFAULT_IS_DISPOSED;

    ResourceArray model;
    Session session;
    String name = PENDING;
    Collection<Object> children = Collections.emptyList();
    Runnable nameUpdater;
    Runnable childrenUpdater;

    public Experiment(ReadGraph graph, Resource experiment) {
        super(experiment);
        this.session = graph.getSession();
    }

    @Override
    public int getCategory(Runnable updater, NodeContext context) {
        return 0;
    }

    @Override
    public Collection<?> getChildren(final Runnable updater, NodeContext context) {
        childrenUpdater = updater;

        if (children != Collections.emptyList())
            return children;

        session.asyncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                List<Object> result = new ArrayList<Object>();
                try {
                    for (Statement factory : findReportFactories(graph)) {
                        result.add(new ReportFactory(graph, factory));
                    }
                    children = result;
                } catch (DatabaseException e) {
                    children = result;
                }
                updater.run();
            }
        });
        return children;
    }

    @Override
    public ImageDescriptor getImage(Runnable updater, NodeContext context) {
        return Activator.EXPERIMENT_ICON;
    }

    @Override
    public String getLabel(ReadGraph graph) throws DatabaseException {
        String name = LabelerUtil.safeStringRepresentation(graph, resource);
        Resource initialState = graph.getPossibleObject(resource, SimulationResource.getInstance(graph).HasInitialState);
        if (initialState != null)
            name += " (" + LabelerUtil.safeStringRepresentation(graph, initialState) + ")";
        return name;
    }

    Read<String> labelRequest(Resource resource) {
        return new ResourceRead<String>(resource) {
            @Override
            public String perform(ReadGraph graph) throws DatabaseException {
                return getLabel(graph);
            }
        };
    }

    private class NameListener implements Listener<String> {
        private final Object identity;
        private final Resource resource;

        public NameListener(Object identity, Resource resource) {
            assert identity != null;
            assert resource != null;
            this.identity = identity;
            this.resource = resource;
        }

        @Override
        public int hashCode() {
            return identity.hashCode() + 31 * resource.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj)
                return true;
            if (obj == null)
                return false;
            if (getClass() != obj.getClass())
                return false;
            NameListener other = (NameListener) obj;
            return identity.equals(other.identity) && resource.equals(other.resource);
        }

        @Override
        public void exception(Throwable t) {
            ErrorLogger.defaultLogError(t);
        }
        @Override
        public boolean isDisposed() {
            return isDisposed.get();
        }
        @Override
        public void execute(String result) {
            name = result;
            nameUpdater.run();
        }
    }

    @Override
    public String getLabel(final Runnable updater, NodeContext context) {
        nameUpdater = updater;
        if (name != PENDING)
            return name;

        session.asyncRequest(labelRequest(resource), new NameListener(nameUpdater, resource));
        return name;
    }

    @Override
    public Modifier getModifier(String columnId) {
        return new LabelModifier(session, resource) {
            @Override
            public void run(DatabaseException ex) {
                if (ex == null) {
                    refreshName();
                } else {
                    super.run(ex);
                }
            }
        };
    }

    @Override
    public boolean hasChildren(Runnable updater, NodeContext context) {
        return getChildren(updater, context).size() > 0;
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }

    @Override
    public void refresh() {
        refreshName();
        refreshChildren();
    }

    public void refreshName() {
        this.name = PENDING;
        if (nameUpdater != null)
            nameUpdater.run();
    }

    public void refreshChildren() {
        this.children = Collections.emptyList();
        if (childrenUpdater != null)
            childrenUpdater.run();
    }

    Collection<Statement> findReportFactories(ReadGraph g) throws DatabaseException {
        DocumentResource DOC = DocumentResource.getInstance(g);
        return g.getStatements(resource, DOC.HasReportFactory);
    }

    @Override
    public void handleDelete() throws DeleteException {
    }

    @Override
    public void setPath(ResourceArray path) {
        this.model = path;
    }

    @Override
    public ResourceArray getPath() {
        return model;
    }

    public Resource getModel() {
        return model.size() == 0 ? null : model.resources[0];
    }

    @Override
    public void setDisposedCallable(Supplier<Boolean> isDisposed) {
        this.isDisposed = isDisposed;
    }

}