/*******************************************************************************
 * Copyright (c) 2007, 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - #7116 regression fix
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.PropertyVariables;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.utils.ui.AdaptionUtils;
import org.slf4j.LoggerFactory;

public class ContextualHelp extends AbstractHandler {

    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(ContextualHelp.class);

    private static String getPossibleId(ExecutionEvent event) {
        try {
            ISelection sel = HandlerUtil.getCurrentSelection(event);
            Resource resource = WorkbenchSelectionUtils.getPossibleResource(sel);
            Variable variable = WorkbenchSelectionUtils.getPossibleVariable(sel);
            if (sel.isEmpty() && resource == null && variable == null)
                return null;

            return Simantics.getSession().syncRequest(new UniqueRead<String>() {
                @Override
                public String perform(ReadGraph graph) throws DatabaseException {
                    ModelingResources MOD = ModelingResources.getInstance(graph);
                    if (resource != null) {
                        Resource component = graph.getPossibleObject(resource, MOD.ElementToComponent);
                        String id = component != null ? graph.getPossibleRelatedValue2(component, MOD.contextualHelpId, Bindings.STRING) : null;
                        if (id != null)
                            return id;
                        id = graph.getPossibleRelatedValue2(resource, MOD.contextualHelpId, Bindings.STRING);
                        if (id != null)
                            return id;
                    }

                    if (variable != null) {
                        String id = variable.getPossiblePropertyValue(graph, MOD.contextualHelpId, Bindings.STRING);
                        if (id != null)
                            return id;
                    }

                    // TODO: consider removing this block
                    if (sel != null) {
                        PropertyVariables vars = AdaptionUtils.adaptToSingle(sel, PropertyVariables.class);
                        Variable var = vars != null ? vars.getConfiguration() : null;
                        String id = var != null ? var.getPossiblePropertyValue(graph, MOD.contextualHelpId, Bindings.STRING) : null;
                        if (id != null)
                            return id;
                    }

                    return null;
                }
            });
        } catch (DatabaseException e) {
            LOGGER.error("", e);
            return null;
        }
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String id = getPossibleId(event);
        if (id != null)
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(id);
        return null;
    }

}
