/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor.handlers.e4;

import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * @author Tuukka Lehtonen
 */
public class ToggleFocusabilityHandler {

    @CanExecute
    public boolean canExecute(@Active MPart part) {
        if (!(part.getObject() instanceof CompatibilityEditor))
            return false;
        CompatibilityEditor editor = (CompatibilityEditor) part.getObject();
        if (!(editor.getPart() instanceof DiagramEditor))
            return false;
        return true;
    }
    
	@Execute
	public void execute(@Optional MToolItem toolItem) {
		ILayersEditor le = getLayers();
		if (le != null) {
			boolean b = le.getIgnoreFocusSettings();
			le.setIgnoreFocusSettings( !b );

			if (toolItem != null) {
			    toolItem.setSelected(!b);
			    toolItem.setTooltip((!b ? "Deny" : "Allow") + " Focusing and Editing of Images");
			}
		}
	}

	protected ILayersEditor getLayers() {
		DiagramEditor editor = getEditor();
		if (editor == null)
			return null;
		return getLayers(editor);
	}

	protected ILayersEditor getLayers(DiagramEditor editor) {
		// The diagram might not be available since the diagram editor loads it asynchronously.
		IDiagram diagram = (IDiagram) editor.getAdapter(IDiagram.class);
		if (diagram == null)
			return null;
		//System.out.println("getLayersEditor(" + diagram + ")");
		ILayersEditor le = diagram.getHint(DiagramHints.KEY_LAYERS_EDITOR);
		return le;
	}

	protected DiagramEditor getEditor() {
		IEditorPart editorPart = WorkbenchUtils.getActiveEditor();
		if (editorPart == null)
			return null;
		if (editorPart instanceof DiagramEditor) {
			DiagramEditor editor = (DiagramEditor) editorPart;
			return editor;
		}
		return null;
	}

}
