/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagram.style;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.document.DocumentResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.nodes.Decoration;
import org.simantics.scenegraph.g2d.nodes.DecorationSVGNode;
import org.simantics.scenegraph.g2d.nodes.SVGNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.utils.datastructures.map.Tuple;

/**
 * @author Antti Villberg
 */
public class DocumentDecorationStyle extends StyleBase<DocumentResult> {

    private static final String DECORATION_NODE_NAME = "documentDecorations";

    private Set<Resource> getContexts(ReadGraph graph, Resource element) throws DatabaseException {

        ModelingResources MOD = ModelingResources.getInstance(graph);
    	HashSet<Resource> result = new HashSet<Resource>();
    	result.add(element);
        Resource config = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (config != null) result.add(config);
        config = graph.getPossibleObject(element, MOD.DiagramConnectionToConnection);
        if (config != null) result.add(config);
        return result;
    	
    }
    
    @Override
    public DocumentResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
    	
        DocumentResource DOC = DocumentResource.getInstance(graph);
        for(Resource r : getContexts(graph, element)) {
        	if(graph.hasStatement(r, DOC.HasDocumentation)) {
                AffineTransform transform = DiagramGraphUtil.getAffineTransform(graph, element);
        		return new DocumentResult(transform);
        	}
        }
        
        return null;
        
    }

    @Override
    public void applyStyleForNode(EvaluationContext observer, INode node, DocumentResult result) {
        if (result == null) {
            ProfileVariables.denyChild(node, "", DECORATION_NODE_NAME);
            return;
        }

        SVGNode svgNode = ProfileVariables.claimChild(node, "", DECORATION_NODE_NAME, DecorationSVGNode.class, observer);

        Rectangle2D bounds = NodeUtil.getLocalBounds(node, Decoration.class);

        double tx = bounds.getX();
        double ty = bounds.getY();
        double h = bounds.getHeight();
        
        svgNode.setZIndex( Integer.MAX_VALUE );
        svgNode.setTransform( AffineTransform.getTranslateInstance(tx, ty+h) ); 
        svgNode.setData(Activator.DOCUMENT_SVG_TEXT);

    }

    @Override
    protected void cleanupStyleForNode(INode node) {
        ProfileVariables.denyChild(node, "", DECORATION_NODE_NAME);
    }

    @Override
    public String toString() {
        return "Document decoration";
    }

}

/**
 * This is needed to keep the issue decoration up-to-date when its parent
 * element moves.
 */
class DocumentResult extends Tuple {
    public DocumentResult(AffineTransform transform) {
        super(transform);
    }
}
