/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagram.monitor;

import org.simantics.basicexpression.Expressions;
import org.simantics.basicexpression.analysis.ExpressionException;
import org.simantics.common.format.Formatter;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.ui.ErrorLogger;

final public class MonitorValue extends TernaryRead<String, Formatter, Variable, String> {

    public MonitorValue(String expression, Formatter formatter, Variable variable) {
        super(expression, formatter, variable);
    }

    @Override
    public String perform(ReadGraph graph) throws DatabaseException {
        if (parameter == null)
            return null;

        MonitorExpressionVisitor visitor = new MonitorExpressionVisitor(graph, parameter2, parameter3);
        try {
            Expressions.evaluate(parameter, visitor);
            Object result = visitor.getResult();
            if (result instanceof Throwable)
                return ((Throwable) result).getLocalizedMessage();
            return result != null ? result.toString() : "null";
        } catch (ExpressionException e) {
            ErrorLogger.defaultLogError(e);
            return e.getMessage();
        }
    }

}
