package org.simantics.modeling.ui.diagram.monitor;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.strings.StringUtils;

public class AvailableFormatFactory extends ReadFactoryImpl<Resource, Map<String, Object>> {

	@Override
	public Map<String, Object> perform(ReadGraph graph, Resource input) throws DatabaseException {
		
		Layer0 L0 = Layer0.getInstance(graph);
		DiagramResource DIA = DiagramResource.getInstance(graph);
		Instances query = graph.adapt(DIA.RealizedFormatter, Instances.class);
		Resource model = graph.syncRequest(new PossibleModel(input));
		if (model == null) return Collections.emptyMap();

		Map<String, Resource> result = new TreeMap<>(AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
		for (Resource template : query.find(graph, model)) {
			String sortKey = graph.getPossibleRelatedAdapter(template, DIA.RealizedFormatter_sortKey, String.class);
			result.put(StringUtils.safeString(sortKey), template);
		}
		String[] keys = new String[result.size()];
		Object[] values = new Object[result.size()];
		int i = 0;
		for (Resource template : result.values()) {
			String label = graph.getPossibleRelatedAdapter(template, L0.HasLabel, String.class);
			String format = graph.getPossibleRelatedValue(template, DIA.RealizedFormatter_HasDefinition, Bindings.STRING);
			keys[i] = "" + label + " (" + format + ")";
			values[i] = template;
			++i;
		}
		return ArrayMap.make(keys, values);

	}

}
