/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.actions.e4;

import javax.inject.Named;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.simantics.db.Resource;
import org.simantics.modeling.ui.diagram.PageSettingsDialog;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.utils.ui.workbench.WorkbenchUtils;


/**
 * A Handler that shows PageSettings Dialog for DiagramViewer
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 */
public class PageSettingsHandler {

    @CanExecute
    public boolean canExecute(@Named(IServiceConstants.ACTIVE_PART) MPart mActiveEditor) {
        // TODO: Fix this when we get rid of CompatibilityEditors
        IEditorPart activeEditor = null;
        if (mActiveEditor != null && mActiveEditor.getObject() instanceof CompatibilityEditor) {
            CompatibilityEditor compatEditor = (CompatibilityEditor) mActiveEditor.getObject();
            activeEditor = compatEditor.getEditor();
        } else {
            // TODO: This is not good practice with E4 but an OK fallback for now
//            activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        if (activeEditor == null)
            return false;
        
        if (activeEditor instanceof DiagramEditor) {
            DiagramEditor editor = (DiagramEditor) activeEditor;
            IResourceEditorInput input = (IResourceEditorInput)editor.getEditorInput();
            Resource diagramResource = input.getResource();
            if (diagramResource != null)
                return true;
        }
        return false;
    }
    
    @Execute
    public void execute(){
        IWorkbenchPart ap = WorkbenchUtils.getActiveEditor();
        if (ap instanceof DiagramEditor) {
            DiagramEditor editor = (DiagramEditor) ap;
            IResourceEditorInput input = (IResourceEditorInput)editor.getEditorInput();
            Resource diagramResource = input.getResource();
            if (diagramResource == null)
                return;

            PageSettingsDialog dialog = new PageSettingsDialog(diagramResource, ap.getSite().getShell());
            if (dialog.open() == PageSettingsDialog.OK) {
                dialog.applySettings();
            }
        }
    }

}
