package org.simantics.modeling.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagram.renaming.ComponentsRenamingDialog;
import org.simantics.modeling.ui.diagram.renaming.ComponentsRenamingModel;

/**
 * @author Hannu Niemist&ouml;
 */
public class RenameDiagramComponents implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if (!(target instanceof Resource))
            return null;
        final Resource composite = (Resource)target;

        return new Runnable() {
            @Override
            public void run() {
                try {
                    ComponentsRenamingModel model = Simantics.getSession().syncRequest(new UniqueRead<ComponentsRenamingModel>() {
                        @Override
                        public ComponentsRenamingModel perform(ReadGraph graph) throws DatabaseException {
                            return new ComponentsRenamingModel().read(graph, composite);
                        }
                    });
                    ComponentsRenamingDialog dialog = new ComponentsRenamingDialog(
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),
                            model);
                    if(dialog.open() == Dialog.OK) {
                        Simantics.getSession().syncRequest(new WriteRequest() {
                            @Override
                            public void perform(WriteGraph graph)
                                    throws DatabaseException {
                                graph.markUndoPoint();
                                model.write(graph);
                            }
                        });
                    }
                } catch (DatabaseException e) {
                    Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "RenameDiagramComponents action failed, see exception for details", e));
                }
            }
        };
    }

}
