package org.simantics.modeling.ui.actions;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.document.DocumentResource;
import org.simantics.layer0.Layer0;
import org.simantics.ui.SimanticsUI;

public class NewDocument implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if(!(target instanceof Resource))
            return null;
        final Resource model = (Resource)target;
        return new Runnable() {

            @Override
            public void run() {
                SimanticsUI.getSession().asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.markUndoPoint();
                        
                        Layer0 L0 = Layer0.getInstance(graph);
                        DocumentResource DOC = DocumentResource.getInstance(graph);

                        String name = NameUtils.findFreshEscapedName(graph, "Document", model, L0.ConsistsOf);

                        // Create DOC.WikiDocument instance
                        Resource wikiDocument = graph.newResource();
                        graph.claim(wikiDocument, L0.InstanceOf, DOC.WikiDocument);
                        graph.claim(wikiDocument, L0.PartOf, model);
                        graph.claimLiteral(wikiDocument, L0.HasName, name);

                        // Bind an empty document scene graph to the new :DOC.WikiDocument
                        Resource documentType = graph.getSingleObject(DOC.WikiDocument_WikiDocumentBinding, DOC.DocumentTypeBinding_HasDocumentType);
                        Resource document = graph.newResource();
                        graph.claim(document, L0.InstanceOf, null, DOC.ScenegraphDocument);
                        graph.claimLiteral(document, L0.HasName, "Documentation");
                        graph.claim(wikiDocument, DOC.HasDocumentation, document);
                        graph.claim(document, L0.PartOf, wikiDocument);

                        Resource scenegraph = graph.newResource();
                        graph.claim(scenegraph, L0.InstanceOf, null, documentType);
                        graph.claimLiteral(scenegraph, L0.HasName, "Scenegraph");
                        graph.claim(scenegraph, L0.PartOf, document);
                        graph.claim(document, DOC.ScenegraphDocument_scenegraph, scenegraph);

                    }
                });
            }
            
        };
    }

}
