package org.simantics.modeling.ui.actions;

import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.modeling.flags.MergeFlags;

/**
 * @author Hannu Niemist&ouml;
 * @author Tuukka Lehtonen
 */
public class MergeRelatedFlagsHandler extends FlagOperationHandler {

    @Override
    protected void perform(IProgressMonitor monitor, WriteGraph graph, List<Resource> flags,
            ICanvasContext canvasContext) throws DatabaseException {
        monitor.beginTask("Merge Related Flags", IProgressMonitor.UNKNOWN);
        MergeFlags.expandFlagSet(graph, flags);
        MergeFlagsHandler.performMerge(graph, flags, canvasContext);
    }

}
