package org.simantics.modeling.ui.actions;

import java.util.Collections;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.runtime.DiagramSelectionUpdater;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.modeling.flags.MergeFlags;

/**
 * @author Hannu Niemist&ouml;
 * @author Tuukka Lehtonen
 */
public class MergeFlagsHandler extends FlagOperationHandler {

    protected void perform(IProgressMonitor monitor, WriteGraph graph, List<Resource> flags, ICanvasContext canvasContext) throws DatabaseException {
        monitor.beginTask("Merge Selected Flags", IProgressMonitor.UNKNOWN);
        performMerge(graph, flags, canvasContext);
    }

    public static void performMerge(WriteGraph graph, List<Resource> flags, ICanvasContext canvasContext) throws DatabaseException {
        final String text = MergeFlags.validateForMerge(graph, flags);
        if(text != null) {
            System.err.println(text);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {
                @Override
                public void run() {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()
                    .getActiveEditor().getEditorSite().getActionBars().getStatusLineManager()
                    .setErrorMessage(text);
                }
            });
        }
        else {
            String result = MergeFlags.merge(graph, flags);
            if(result != null && !result.isEmpty()) {
                System.err.println(result); // Should not happen because of prevalidation
            } else {
                if (canvasContext != null) {
                    // Make sure the diagram selection is set to the
                    // merged flag after the merge.
                    new DiagramSelectionUpdater( canvasContext )
                    .setNewSelection(0, Collections.singleton( flags.get(0) ))
                    .setOneshot(true)
                    .track();
                }
            }
        }
    }

}
