/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation.utils;

import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.sysdyn.expressionParser.ExpressionParser;
import org.simantics.sysdyn.expressionParser.ParseException;
import org.simantics.sysdyn.expressionParser.Token;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.Model;
import org.simantics.sysdyn.representation.ModuleType;
import org.simantics.sysdyn.representation.Sheet;
import org.simantics.sysdyn.representation.Variable;

public class SheetFormatUtils {
    public static String reformatSheetReferences(Variable v, String expression) {
        if (expression == null || !expression.contains("(")) {
            return expression;
        }
        ExpressionParser parser = new ExpressionParser(new StringReader(expression));
        try {
            parser.expr();
            HashMap<String, List<Token>> functionCalls = parser.getFunctionCallReferences();
            for (String key : functionCalls.keySet()) {
                String[] parts = key.split("\\.");
                Configuration current = v.getParentConfiguration();
                ModuleType moduleType = current.getModuleType();
                if (moduleType != null && moduleType.getParent() != null && moduleType.getParent() instanceof Model) {
                    current = ((Model)moduleType.getParent()).getModelConfiguration();
                }
                IElement found = null;
                int i = 0;
                while (i < parts.length && current != null) {
                    found = null;
                    if (current instanceof Configuration) {
                        for (IElement e : current.getElements()) {
                            if (e instanceof Configuration && ((Variable)e).getName().equals(parts[i])) {
                                found = e;
                                break;
                            }
                            if (!(e instanceof Variable) || !((Variable)e).getName().equals(parts[i])) continue;
                            found = e;
                            break;
                        }
                    }
                    current = found;
                    ++i;
                }
                if (current == null || !(current instanceof Sheet)) continue;
                String tmp = "";
                int start = 0;
                int end = 0;
                int call = 0;
                String cellOrRange = null;
                while ((call = expression.indexOf(String.valueOf(key) + "(", end)) >= 0) {
                    start = expression.indexOf("(", call);
                    tmp = String.valueOf(tmp) + expression.substring(end, start);
                    end = expression.indexOf(")", start) + 1;
                    if (start < 0 || end < 0 || end < start) break;
                    cellOrRange = expression.substring(start, end);
                    cellOrRange = cellOrRange.substring(1, cellOrRange.length() - 1);
                    cellOrRange = cellOrRange.trim();
                    cellOrRange = cellOrRange.replace(" ", "");
                    Pattern p = Pattern.compile("[-\\+\\*\\/\\(\\)\\{\\}\\[\\],\\.\\t\\n\\r\\f]");
                    Matcher m = p.matcher(cellOrRange);
                    if (m.find() || cellOrRange.split(":").length > 2 || cellOrRange.length() == 0) continue;
                    ((Sheet)((Object)current)).use(cellOrRange);
                    cellOrRange = cellOrRange.replace(":", "_");
                    tmp = String.valueOf(tmp) + "." + cellOrRange;
                }
                expression = tmp = String.valueOf(tmp) + expression.substring(end, expression.length());
            }
        }
        catch (ParseException parseException) {}
        return expression;
    }
}

