/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.objmap.IMapping;
import org.simantics.objmap.IMappingSchema;
import org.simantics.objmap.MappingException;
import org.simantics.objmap.Mappings;
import org.simantics.sysdyn.manager.SysdynConsole;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.SysdynSchema;

public class LoadRepresentation {
    public static IMapping loadMappedMapping(Session session, final Resource configuration) throws DatabaseException {
        return (IMapping)session.syncRequest((Read)new Read<IMapping>(){

            public IMapping perform(ReadGraph graph) throws DatabaseException {
                SysdynSchema schema = new SysdynSchema(graph);
                IMapping mapping = Mappings.createWithoutListening((IMappingSchema)schema);
                try {
                    mapping.map(graph, configuration);
                }
                catch (MappingException e) {
                    SysdynConsole.INSTANCE.message("Error: Mapping is broken! Find the problem, fix it and restart the program.\nJava error message:\n" + e.getMessage());
                    throw e;
                }
                return mapping;
            }
        });
    }

    public static Configuration loadConfiguration(Session session, final Resource configuration) throws DatabaseException {
        return (Configuration)session.syncRequest((Read)new Read<Configuration>(){

            public Configuration perform(ReadGraph graph) throws DatabaseException {
                SysdynSchema schema = new SysdynSchema(graph);
                IMapping mapping = Mappings.createWithoutListening((IMappingSchema)schema);
                try {
                    return (Configuration)mapping.map(graph, configuration);
                }
                catch (MappingException e) {
                    SysdynConsole.INSTANCE.message("Error: Mapping is broken! Find the problem, fix it and restart the program.\nJava error message:\n" + e.getMessage());
                    throw e;
                }
            }
        });
    }

    public static IElement loadElement(Session session, final Resource element) throws DatabaseException {
        return (IElement)session.syncRequest((Read)new Read<IElement>(){

            public IElement perform(ReadGraph graph) throws DatabaseException {
                SysdynSchema schema = new SysdynSchema(graph);
                IMapping mapping = Mappings.createWithoutListening((IMappingSchema)schema);
                try {
                    return (IElement)mapping.map(graph, element);
                }
                catch (MappingException e) {
                    SysdynConsole.INSTANCE.message("Error: Mapping is broken! Find the problem, fix it and restart the program.\nJava error message:\n" + e.getMessage());
                    throw e;
                }
            }
        });
    }
}

