/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.properties.LabelPropertyTabContributor;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.widgets.modules.ModuleOutputEditingSupport;
import org.simantics.sysdyn.ui.properties.widgets.modules.ReferenceRow;
import org.simantics.sysdyn.ui.properties.widgets.modules.ReferenceRowLabelProvider;
import org.simantics.sysdyn.ui.properties.widgets.modules.ReferenceTable;
import org.simantics.sysdyn.ui.properties.widgets.modules.RowProvider;

public class ModuleOutputTab
extends LabelPropertyTabContributor {
    public static final String FIRSTCOLUMN = "Output in module";
    public static final String SECONDCOLUMN = "Referes to input";

    public ModuleOutputTab(Object id) {
        super(id);
    }

    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        ReferenceTable referenceTable = new ReferenceTable(body, support, 0);
        String[] titles = new String[]{FIRSTCOLUMN, SECONDCOLUMN};
        int[] bounds = new int[]{200, 200};
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn column = new TableViewerColumn(referenceTable.getTableViewer(), 0);
            column.getColumn().setText(titles[i]);
            column.getColumn().setWidth(bounds[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(false);
            column.setEditingSupport((EditingSupport)new ModuleOutputEditingSupport(referenceTable.getTableViewer(), i));
            ++i;
        }
        referenceTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        referenceTable.setLabelProvider((IBaseLabelProvider)new ReferenceRowLabelProvider());
        RowProvider rp = new RowProvider(){

            @Override
            public ArrayList<ReferenceRow> getRows(ReadGraph graph, Resource module) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                StructuralResource2 sr2 = StructuralResource2.getInstance((ReadGraph)graph);
                ArrayList<ReferenceRow> result = new ArrayList<ReferenceRow>();
                Resource instanceOf = graph.getPossibleObject(module, l0.InstanceOf);
                if (instanceOf == null) {
                    return result;
                }
                Resource configuration = graph.getSingleObject(instanceOf, sr2.IsDefinedBy);
                for (Resource variable : (Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, l0.ConsistsOf, sr.Variable))) {
                    if (!graph.hasStatement(variable, sr.IsOutput)) continue;
                    Resource dependency = null;
                    for (Resource dep : graph.getObjects(module, sr.Variable_isTailOf)) {
                        Resource refersTo = graph.getPossibleObject(dep, sr.Dependency_refersTo);
                        if (refersTo == null || !refersTo.equals(variable)) continue;
                        dependency = dep;
                        break;
                    }
                    ReferenceRow rr = new ReferenceRow(module, dependency, variable);
                    result.add(rr);
                }
                return result;
            }
        };
        referenceTable.setRowProvider(rp);
    }
}

