/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.contributions;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.swt.ImagerContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.issues.Severity;
import org.simantics.issues.common.MaxIssueSeverityRecursive;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.browser.nodes.BookNode;
import org.simantics.sysdyn.ui.browser.nodes.ConfigurationNode;
import org.simantics.sysdyn.ui.browser.nodes.ExperimentNode;
import org.simantics.sysdyn.ui.browser.nodes.ExperimentsFolder;
import org.simantics.sysdyn.ui.browser.nodes.FunctionLibraryNode;
import org.simantics.sysdyn.ui.browser.nodes.FunctionNode;
import org.simantics.sysdyn.ui.browser.nodes.FunctionsFolder;
import org.simantics.sysdyn.ui.browser.nodes.InitialCondition;
import org.simantics.sysdyn.ui.browser.nodes.InitialConditionsFolder;
import org.simantics.sysdyn.ui.browser.nodes.InputNode;
import org.simantics.sysdyn.ui.browser.nodes.ModelNode;
import org.simantics.sysdyn.ui.browser.nodes.ModuleNode;
import org.simantics.sysdyn.ui.browser.nodes.ModuleTypeNode;
import org.simantics.sysdyn.ui.browser.nodes.ModulesNode;
import org.simantics.sysdyn.ui.browser.nodes.SCLModule;
import org.simantics.sysdyn.ui.browser.nodes.SCLModulesFolder;
import org.simantics.sysdyn.ui.browser.nodes.SharedFunctionLibraryNode;
import org.simantics.sysdyn.ui.browser.nodes.SharedFunctionsFolder;
import org.simantics.sysdyn.ui.browser.nodes.SheetNode;
import org.simantics.sysdyn.ui.browser.nodes.VariableNode;
import org.simantics.utils.ui.gfx.DecorationOverlayIcon;

public class AbstractNodeImager
extends ImagerContributor<AbstractNode<Resource>> {
    public ImageDescriptor getDescriptor(ReadGraph graph, AbstractNode<Resource> node) throws DatabaseException {
        String image = null;
        if (node instanceof SharedFunctionsFolder) {
            image = "icons/folder_link.png";
        } else if (node instanceof ExperimentsFolder || node instanceof ModulesNode || node instanceof FunctionsFolder || node instanceof FunctionLibraryNode || node instanceof SCLModulesFolder || node instanceof InitialConditionsFolder || node instanceof SharedFunctionLibraryNode) {
            image = "icons/folder.png";
        } else if (node instanceof ModuleTypeNode || node instanceof ModuleNode || node instanceof ConfigurationNode) {
            image = "icons/bricks.png";
        } else if (node instanceof SCLModule) {
            image = "icons/box.png";
        } else if (node instanceof InitialCondition) {
            image = "icons/table.png";
        } else if (node instanceof ExperimentNode) {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            image = graph.isInstanceOf((Resource)node.data, sr.PlaybackExperiment) ? "icons/timeline_marker.png" : (graph.isInstanceOf((Resource)node.data, sr.GameExperiment) ? "icons/time_go.png" : (graph.isInstanceOf((Resource)node.data, sr.SensitivityAnalysisExperiment) ? "icons/time_rainbow.png" : "icons/time.png"));
        } else if (node instanceof InputNode) {
            image = "icons/brick_link.png";
        } else if (node instanceof ModelNode) {
            image = "icons/chart_organisation.png";
        } else if (node instanceof FunctionNode) {
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            if (graph.hasStatement((Resource)node.data, l0.PartOf, sr.Built$in_Functions)) {
                image = "icons/sysdynFunction.png";
            } else if (graph.hasStatement((Resource)node.data, l0.PartOf, sr.Built$in_Functions_Modelica_Functions)) {
                image = "icons/modelicaFunction.png";
            } else if (graph.hasStatement((Resource)node.data, l0.PartOf, sr.Built$in_Functions_Modelica_Array_Functions)) {
                image = "icons/modelicaArrayFunction.png";
            } else if (graph.hasStatement((Resource)node.data, l0.PartOf, sr.Built$in_Functions_Vensim_Functions)) {
                image = "icons/vensimFunction.png";
            } else {
                Resource r = graph.getPossibleObject((Resource)node.data, l0.PartOf);
                if (r != null) {
                    boolean shared = false;
                    do {
                        shared = graph.isInstanceOf(r, sr.SharedFunctionOntology);
                        r = graph.getPossibleObject(r, l0.PartOf);
                    } while (!shared && r != null);
                    image = shared ? "icons/functionLink.png" : "icons/function.png";
                }
            }
        } else if (node instanceof VariableNode) {
            image = "icons/brick.png";
        } else if (node instanceof BookNode) {
            image = "icons/table_multiple.png";
        } else if (node instanceof SheetNode) {
            image = "icons/table.png";
        }
        if (image != null) {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource(image));
            Severity maxSeverity = this.getMaxSeverity(graph, node);
            if (maxSeverity == null) {
                return id;
            }
            return this.getDecoration(id, maxSeverity);
        }
        return null;
    }

    private Severity getMaxSeverity(ReadGraph graph, AbstractNode<Resource> node) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource.getInstance((ReadGraph)graph);
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        HashSet<Resource> issueTypes = new HashSet<Resource>();
        issueTypes.add(SR.Variable);
        issueTypes.add(SR.Configuration);
        issueTypes.add(SR.Module);
        Resource data = (Resource)node.data;
        if (node instanceof ModuleTypeNode) {
            Resource symbol = (Resource)node.data;
            Resource moduleType = graph.getPossibleObject(symbol, L0.PartOf);
            data = graph.getPossibleObject(moduleType, StructuralResource2.getInstance((ReadGraph)graph).IsDefinedBy);
        } else if (node instanceof ModuleNode) {
            Resource moduleType = graph.getPossibleObject((Resource)node.data, L0.InstanceOf);
            data = graph.getPossibleObject(moduleType, StructuralResource2.getInstance((ReadGraph)graph).IsDefinedBy);
        } else if (node instanceof ModelNode) {
            data = graph.getPossibleObject((Resource)node.data, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration);
        }
        Severity maxSeverity = this.getMaxSeverityStructural(graph, data, issueTypes, null);
        return maxSeverity;
    }

    private Severity getMaxSeverityStructural(ReadGraph graph, Resource resource, HashSet<Resource> issueTypes, Severity severity) throws DatabaseException {
        if (resource == null) {
            return severity;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        Resource data = resource;
        Severity maxSeverity = (Severity)graph.syncRequest((AsyncRead)new MaxIssueSeverityRecursive(data, L0.ConsistsOf, issueTypes));
        if (graph.isInstanceOf(data, SR.Configuration)) {
            Collection moduleChildren = (Collection)graph.syncRequest((Read)new ModuleChildren(data));
            for (Resource r : moduleChildren) {
                Resource moduleType = graph.getPossibleObject(r, L0.InstanceOf);
                Resource configuration = graph.getPossibleObject(moduleType, StructuralResource2.getInstance((ReadGraph)graph).IsDefinedBy);
                if (configuration == null) continue;
                maxSeverity = this.getMaxSeverityStructural(graph, configuration, issueTypes, maxSeverity);
            }
        }
        return Severity.moreSevere((Severity)maxSeverity, (Severity)severity);
    }

    private ImageDescriptor getDecoration(ImageDescriptor original, Severity severity) {
        ImageDescriptor img = Activator.getDefault().getImageRegistry().getDescriptor(severity.toString());
        if (original == null || original.getImageData() == null) {
            return img;
        }
        return new DecorationOverlayIcon(original, img, 2);
    }

    private class ModuleChildren
    implements Read<Collection<Resource>> {
        Resource configuration;

        public ModuleChildren(Resource configuration) {
            this.configuration = configuration;
        }

        public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
            return (Collection)graph.syncRequest((Read)new ObjectsWithType(this.configuration, Layer0.getInstance((ReadGraph)graph).ConsistsOf, SysdynResource.getInstance((ReadGraph)graph).Module));
        }
    }
}

