/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart;

import java.net.URL;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.ChartPanelElement;
import org.simantics.jfreechart.internal.Activator;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.utils.datastructures.Pair;

public class ChartPanelHeader
extends Composite {
    public static int HEADER_MINIMUM_WIDTH = 250;
    private ChartPanelElement element;
    private Resource resource;
    private Label name;
    private Canvas iconCanvas;
    private Image icon;
    private ToolItem minimize;
    private ToolItem remove;
    private Color defaultColor;
    private Color darker;
    private Color evenDarker;
    private Image gradientBackgroundImage;
    private Image borderImage;
    private static ImageDescriptor closeDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/close.gif"));
    private static Image closeImage = closeDescriptor.createImage();
    private static ImageDescriptor minimizeDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/minimize.gif"));
    private static Image minimizeImage = minimizeDescriptor.createImage();
    private static ImageDescriptor maximizeDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/maximize.gif"));
    private static Image maximizeImage = maximizeDescriptor.createImage();
    private static ImageDescriptor lineChartDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/chart_line_light.png"));
    private static Image lineChartImage = lineChartDescriptor.createImage();
    private static ImageDescriptor barChartDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/chart_bar_light.png"));
    private static Image barChartImage = barChartDescriptor.createImage();
    private static ImageDescriptor pieChartDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/chart_pie_light.png"));
    private static Image pieChartImage = pieChartDescriptor.createImage();
    private DragSourceListener dragSourceListener;
    private DragSource source;

    public ChartPanelHeader(Composite c, ChartPanelElement element, Resource chartResource, int style) {
        super(c, style);
        this.resource = chartResource;
        this.element = element;
        GridLayoutFactory.fillDefaults().margins(3, 0).numColumns(3).applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this);
        this.iconCanvas = new Canvas((Composite)this, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).hint(16, 16).applyTo((Control)this.iconCanvas);
        this.iconCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ChartPanelHeader.this.icon != null) {
                    e.gc.drawImage(ChartPanelHeader.this.icon, 0, 0);
                }
            }
        });
        this.name = new Label((Composite)this, 0);
        try {
            Pair result = (Pair)SimanticsUI.getSession().syncRequest((Read)new Read<Pair<String, Image>>(){

                public Pair<String, Image> perform(ReadGraph graph) throws DatabaseException {
                    JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    String label = (String)graph.getPossibleRelatedValue(ChartPanelHeader.this.resource, l0.HasLabel);
                    Image image = null;
                    Resource plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(ChartPanelHeader.this.resource, l0.ConsistsOf, jfree.Plot));
                    if (plot != null) {
                        image = graph.isInstanceOf(plot, jfree.CategoryPlot) ? barChartImage : (graph.isInstanceOf(plot, jfree.PiePlot) ? pieChartImage : lineChartImage);
                    }
                    return new Pair((Object)label, image);
                }
            }, (org.simantics.db.procedure.Listener)new org.simantics.db.procedure.Listener<Pair<String, Image>>(){

                public void execute(final Pair<String, Image> result) {
                    if (result == null) {
                        return;
                    }
                    ChartPanelHeader.this.name.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ChartPanelHeader.this.name.isDisposed() && result.first != null) {
                                ChartPanelHeader.this.name.setText((String)result.first);
                            }
                            if (!ChartPanelHeader.this.iconCanvas.isDisposed() && result.second != null) {
                                ChartPanelHeader.this.icon = (Image)result.second;
                                ChartPanelHeader.this.iconCanvas.redraw();
                                ChartPanelHeader.this.layout();
                            }
                        }
                    });
                }

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public boolean isDisposed() {
                    return ChartPanelHeader.this.name.isDisposed();
                }
            });
            this.name.setText((String)result.first);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            this.name.setText("No label");
        }
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.name);
        ToolBar toolbar = new ToolBar((Composite)this, 0x800000);
        this.minimize = new ToolItem(toolbar, 8);
        this.minimize.addSelectionListener((SelectionListener)new MinimizeListener());
        if (this.isMinimized()) {
            this.minimize.setToolTipText("Expand");
            this.minimize.setImage(maximizeImage);
        } else {
            this.minimize.setToolTipText("Minimize");
            this.minimize.setImage(minimizeImage);
        }
        this.remove = new ToolItem(toolbar, 8);
        this.remove.setImage(closeImage);
        this.remove.addSelectionListener((SelectionListener)new RemoveChartListener());
        this.remove.setToolTipText("Remove");
        int operations = 2;
        this.source = new DragSource((Control)this.name, operations);
        Transfer[] types = new Transfer[]{LocalObjectTransfer.getTransfer()};
        this.source.setTransfer(types);
        this.dragSourceListener = new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                if (ChartPanelHeader.this.name.isDisposed()) {
                    event.doit = false;
                }
                event.detail = 4;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = new StructuredSelection((Object)ChartPanelHeader.this.resource);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        };
        this.source.addDragListener(this.dragSourceListener);
        this.name.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ChartPanelHeader.this.dragSourceListener != null && ChartPanelHeader.this.source != null && !ChartPanelHeader.this.source.isDisposed()) {
                    ChartPanelHeader.this.source.removeDragListener(ChartPanelHeader.this.dragSourceListener);
                }
            }
        });
        this.setBackgroundImage(this.getGradientBackgroundImage());
        this.setBackgroundMode(2);
        this.addListener(6, new EnterListener());
        this.addListener(7, new ExitListener());
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.addListener(6, (Listener)new EnterListener());
            child.addListener(7, (Listener)new ExitListener());
            ++n2;
        }
    }

    private void createColors() {
        if (this.defaultColor == null) {
            this.defaultColor = this.getDisplay().getSystemColor(22);
            try {
                this.defaultColor = new Color((Device)this.getDisplay(), this.defaultColor.getRed() + 500, this.defaultColor.getGreen() + 10, this.defaultColor.getBlue() + 10);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (this.darker == null) {
            try {
                this.darker = new Color((Device)this.getDisplay(), this.defaultColor.getRed() - 30, this.defaultColor.getGreen() - 30, this.defaultColor.getBlue() - 30);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.darker = this.defaultColor;
            }
        }
        if (this.evenDarker == null) {
            try {
                this.evenDarker = new Color((Device)this.getDisplay(), this.defaultColor.getRed() - 50, this.defaultColor.getGreen() - 50, this.defaultColor.getBlue() - 50);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.evenDarker = this.defaultColor;
            }
        }
    }

    private Image getHighlightedGradientBackgroundImage() {
        this.createColors();
        this.layout();
        Point size = this.getSize();
        this.borderImage = new Image((Device)this.getDisplay(), 1, Math.max(1, size.y));
        GC gc = new GC((Drawable)this.borderImage);
        gc.setForeground(this.defaultColor);
        gc.setBackground(this.evenDarker);
        gc.fillGradientRectangle(0, 0, 1, size.y, true);
        gc.dispose();
        return this.borderImage;
    }

    private Image getGradientBackgroundImage() {
        this.createColors();
        this.layout();
        Point size = this.computeSize(-1, -1);
        if (this.gradientBackgroundImage == null) {
            this.gradientBackgroundImage = new Image((Device)this.getDisplay(), 1, Math.max(1, size.y));
            GC gc = new GC((Drawable)this.gradientBackgroundImage);
            gc.setForeground(this.defaultColor);
            gc.setBackground(this.darker);
            gc.fillGradientRectangle(0, 0, 1, size.y, true);
            gc.dispose();
        }
        return this.gradientBackgroundImage;
    }

    private boolean isMinimized() {
        return this.element.isMinimized();
    }

    private class EnterListener
    implements Listener {
        private EnterListener() {
        }

        public void handleEvent(Event event) {
            ChartPanelHeader.this.setBackgroundImage(ChartPanelHeader.this.getHighlightedGradientBackgroundImage());
        }
    }

    private class ExitListener
    implements Listener {
        private ExitListener() {
        }

        public void handleEvent(Event event) {
            ChartPanelHeader.this.setBackgroundImage(ChartPanelHeader.this.getGradientBackgroundImage());
        }
    }

    private class MinimizeListener
    implements SelectionListener {
        private MinimizeListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ChartPanelHeader.this.isDisposed()) {
                return;
            }
            ChartPanelHeader.this.element.toggleMinimize(true);
            if (!ChartPanelHeader.this.name.isDisposed() && !ChartPanelHeader.this.minimize.isDisposed()) {
                if (ChartPanelHeader.this.isMinimized()) {
                    ChartPanelHeader.this.minimize.setToolTipText("Expand");
                } else {
                    ChartPanelHeader.this.minimize.setToolTipText("Minimize");
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class RemoveChartListener
    implements SelectionListener {
        private RemoveChartListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!ChartPanelHeader.this.isDisposed()) {
                ChartPanelHeader.this.element.remove();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

