package org.simantics.views.swt.client.impl;

import java.io.IOException;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.utils.FileUtils;
import org.simantics.utils.datastructures.map.Tuple;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.views.swt.client.base.SingleSWTViewNode;
import org.simantics.wiki.ui.SimanticsDialect;
import org.simantics.wiki.ui.language.MediaWikiLanguage;

public class SWTWikiBrowser extends SingleSWTViewNode<Browser> {

	private static final long serialVersionUID = 5826022972081217837L;
	
	public String                   document;
	public Variable                 variable;
	public Function1<String, Boolean> navigate;
	public Variable					edited;

	private Tuple                    lastAppliedParametrization;

	@Override
	public void reset() {
		super.reset();
		lastAppliedParametrization = null;
	}
	
	@Override
	public void createControls(Composite parent) {

		GridDataFactory.fillDefaults().grab(true, true).applyTo(parent);
		GridLayoutFactory.fillDefaults().applyTo(parent);

		control = new Browser(parent, style);
		GridDataFactory.fillDefaults().grab(true, true).applyTo(control);

		setProperties();

	}

	public void synchronizeVariable(Variable variable) {
		
	}
	
	public void synchronizeEdited(Variable edited) {
		propertyCallback.apply("edited", edited);
	}

	public void synchronizeDocument(final String document) {
		
		if(document != null) {
			
			final Variable variable = SWTWikiBrowser.this.variable;
			if (variable == null) {
				return;
			}

			Tuple checkParam = new Tuple(document, variable);
			if (checkParam.equals(lastAppliedParametrization))
				return;
			
			lastAppliedParametrization = checkParam;

			try {
				
				String markup = Simantics.getSession().syncRequest(new Read<String>() {
					@Override
					public String perform(ReadGraph graph) throws DatabaseException {
						return SimanticsDialect.INSTANCE.apply(graph, variable, document);
					}
				});

				MarkupParser markupParser = new MarkupParser();
				MediaWikiLanguage language = new MediaWikiLanguage();
				markupParser.setMarkupLanguage(language);
				String htmlContent = markupParser.parseToHtml(markup);
				if (htmlContent == null)
					return;
			
				final Browser control = this.control;
				if (control == null)
					return;
				control.setText(htmlContent);
				
			} catch (DatabaseException e) {
				ErrorLogger.defaultLogError(e);
			}			
			
		}
	}

}
