package org.simantics.views.swt.client.impl;

import java.util.List;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.simantics.scl.runtime.tuple.Tuple;

public class SWTCombo extends SWTComboBase<Combo> {
	
	private static final long serialVersionUID = 3355806440902480450L;

	private final ModifyListener listener = new ModifyListener() {

		@Override
		public void modifyText(ModifyEvent e) {
			
			int selectionIndex = control.getSelectionIndex();
			if (selectionIndex == -1)
			    return;

			String[] items = control.getItems();
			
			String key = items[selectionIndex];
			
			if(modifier != null)
				modifier.apply(key);
			
			selected = key;
			
		}
		
	};
	
	@Override
	public void createControls(Composite parent) {
		
		control = new Combo(parent, style);
		// Must initially add modifylistener before invoking setProperties
		// since setProperties will invoke synchronize*-methods, which do
		// removeModifyListener + addModifyListener. Otherwise modify listener
		// would get added twice to the control.
		control.addModifyListener(listener);
		
		setProperties();
		
	}
	
	public void synchronizeAvailable(List<Tuple> available) {
		
		if(available != null) {
			
	        control.removeModifyListener(listener);
	        control.setData(available);
	        control.clearSelection();
	        try {
	        	control.removeAll();
	        } catch (Throwable t) {
	            t.printStackTrace();
	        }
	        if (available != null) {
	            int index = 0;
	            for(Tuple key : available) {
	            	control.add((String)key.get(0));
	            	control.setData((String)key.get(0), index++);
	            }
	            String selectionKey = (String)control.getData("_SelectionKey");
	            if(selectionKey != null) {
	                Integer selectionIndex = (Integer)control.getData(selectionKey);
	                if(selectionIndex != null) control.select(selectionIndex);
	            }
	        }
	        control.addModifyListener(listener);
			
//			// This seems to be necessary for correct size computations
//			widget.getControl().getParent().layout(true);
		}
	}

	public void synchronizeSelected(String selected) {
		
		if(selected != null) {
			
	        control.removeModifyListener(listener);
	        control.setData("_SelectionKey", selected);
	        Integer selectionIndex = (Integer)control.getData(selected);
	        if(selectionIndex != null) control.select(selectionIndex);
	        control.addModifyListener(listener);
	        		
		}
		
	}
	
}
