/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.validators;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jface.dialogs.IInputValidator;

public class URIValidator
implements IInputValidator {
    private final String[] supportedProtocols;

    public URIValidator() {
        this.supportedProtocols = null;
    }

    public URIValidator(String ... supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String isValid(String newText) {
        try {
            URI u = new URI(newText);
            if (this.supportedProtocols == null) {
                return null;
            }
            String[] stringArray = this.supportedProtocols;
            int n = this.supportedProtocols.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return String.valueOf(u.getScheme()) + ":// is not supported.";
                }
                String p = stringArray[n2];
                if (p.equals(u.getScheme())) {
                    return null;
                }
                ++n2;
            }
        }
        catch (URISyntaxException e) {
            return e.getMessage();
        }
    }
}

