/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.color;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.simantics.utils.ui.color.Color;
import org.simantics.utils.ui.color.ColorValue;
import org.simantics.utils.ui.color.ColorValueComparator;

public class ColorGradient {
    public static final int RGB = 0;
    public static final int HSV = 1;
    protected ArrayList<ColorValue> values;
    protected int type;

    public ColorGradient() {
        this.values = new ArrayList();
        this.type = 0;
    }

    public ColorGradient(ColorGradient copyFrom) {
        this.values = new ArrayList<ColorValue>(copyFrom.values);
        this.type = copyFrom.type;
    }

    public ColorGradient(Collection<ColorValue> values) {
        this.values = new ArrayList<ColorValue>(values);
        Collections.sort(this.values, new ColorValueComparator());
        this.type = 0;
    }

    public ColorGradient(ColorValue[] array) {
        this.values = new ArrayList(array.length);
        ColorValue[] colorValueArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ColorValue c = colorValueArray[n2];
            this.values.add(c);
            ++n2;
        }
        Collections.sort(this.values, new ColorValueComparator());
        this.type = 0;
    }

    public ColorGradient(Collection<ColorValue> values, int type) {
        this.values = new ArrayList<ColorValue>(values);
        Collections.sort(this.values, new ColorValueComparator());
        this.type = type;
    }

    public ColorGradient(ColorValue[] array, int type) {
        this.values = new ArrayList();
        ColorValue[] colorValueArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ColorValue c = colorValueArray[n2];
            this.values.add(c);
            ++n2;
        }
        Collections.sort(this.values, new ColorValueComparator());
        this.type = type;
    }

    private byte[] getRGBColor(double value) {
        int index = 1;
        while (this.values.get(index).getValue() <= value && index < this.values.size() - 1) {
            ++index;
        }
        value -= this.values.get(index - 1).getValue();
        double valuei = 1.0 - (value /= this.values.get(index).getValue() - this.values.get(index - 1).getValue());
        byte[] color = new byte[]{(byte)Math.min(255.0, Math.floor(value * (double)this.values.get(index).getColor().getR() + valuei * (double)this.values.get(index - 1).getColor().getR())), (byte)Math.min(255.0, Math.floor(value * (double)this.values.get(index).getColor().getG() + valuei * (double)this.values.get(index - 1).getColor().getG())), (byte)Math.min(255.0, Math.floor(value * (double)this.values.get(index).getColor().getB() + valuei * (double)this.values.get(index - 1).getColor().getB()))};
        return color;
    }

    private byte[] getHSVColor(double value) {
        double h;
        int index = 1;
        while (this.values.get(index).getValue() <= value && index < this.values.size() - 1) {
            ++index;
        }
        value -= this.values.get(index - 1).getValue();
        double valuei = 1.0 - (value /= this.values.get(index).getValue() - this.values.get(index - 1).getValue());
        if (Float.isNaN(this.values.get(index).getColor().getH())) {
            h = this.values.get(index - 1).getColor().getH();
        } else if (Float.isNaN(this.values.get(index - 1).getColor().getH())) {
            h = this.values.get(index).getColor().getH();
        } else {
            float angle = this.values.get(index).getColor().getH() - this.values.get(index - 1).getColor().getH();
            if (angle > 180.0f) {
                angle -= 360.0f;
            } else if (angle < -180.0f) {
                angle += 360.0f;
            }
            h = (double)this.values.get(index - 1).getColor().getH() + value * (double)angle;
            if (h > 360.0) {
                h -= 360.0;
            } else if (h < 0.0) {
                h += 360.0;
            }
        }
        Color interpolated = new Color(h, value * (double)this.values.get(index).getColor().getS() + valuei * (double)this.values.get(index - 1).getColor().getS(), value * (double)this.values.get(index).getColor().getV() + valuei * (double)this.values.get(index - 1).getColor().getV());
        byte[] color = new byte[]{(byte)interpolated.getR(), (byte)interpolated.getG(), (byte)interpolated.getB()};
        return color;
    }

    public byte[] getGradientArray(int size) {
        byte[] array = new byte[size * 3];
        if (this.values.size() > 1) {
            int i = 0;
            while (i < size) {
                int index = i * 3;
                double value = this.values.get(0).getValue() + (this.values.get(this.values.size() - 1).getValue() - this.values.get(0).getValue()) * (double)i / (double)size;
                byte[] color = this.type == 0 ? this.getRGBColor(value) : this.getHSVColor(value);
                array[index] = color[0];
                array[index + 1] = color[1];
                array[index + 2] = color[2];
                ++i;
            }
        } else if (this.values.size() == 1) {
            byte[] color = new byte[]{(byte)this.values.get(0).getColor().getR(), (byte)this.values.get(0).getColor().getG(), (byte)this.values.get(0).getColor().getB()};
            int i = 0;
            while (i < size) {
                int index = i * 3;
                array[index] = color[0];
                array[index + 1] = color[1];
                array[index + 2] = color[2];
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                int index = i * 3;
                array[index] = -1;
                array[index + 1] = -1;
                array[index + 2] = -1;
                ++i;
            }
        }
        return array;
    }

    public Image getGradientImage(int width, int height, int style) {
        Image image = new Image((Device)Display.getCurrent(), width, height);
        GC gc = new GC((Drawable)image);
        gc.setBackground(Display.getCurrent().getSystemColor(1));
        gc.fillRectangle(0, 0, width, height);
        if (this.values.size() > 1) {
            if (256 == (style | 0x100)) {
                int x = 0;
                while (x < width) {
                    double value = this.values.get(0).getValue() + (this.values.get(this.values.size() - 1).getValue() - this.values.get(0).getValue()) * (double)x / (double)(width - 1);
                    byte[] byteColor = this.type == 0 ? this.getRGBColor(value) : this.getHSVColor(value);
                    org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), byteColor[0] & 0xFF, byteColor[1] & 0xFF, byteColor[2] & 0xFF);
                    gc.setForeground(color);
                    gc.drawLine(x, 0, x, height);
                    color.dispose();
                    ++x;
                }
            } else if (512 == (style | 0x200)) {
                int y = 0;
                while (y < height) {
                    double value = this.values.get(0).getValue() + (this.values.get(this.values.size() - 1).getValue() - this.values.get(0).getValue()) * (double)y / (double)(height - 1);
                    byte[] byteColor = this.type == 0 ? this.getRGBColor(value) : this.getHSVColor(value);
                    org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), byteColor[0] & 0xFF, byteColor[1] & 0xFF, byteColor[2] & 0xFF);
                    gc.setForeground(color);
                    gc.drawLine(0, y, width, y);
                    color.dispose();
                    ++y;
                }
            } else {
                gc.dispose();
                image.dispose();
                SWT.error((int)5);
            }
        } else if (this.values.size() == 1) {
            org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), this.values.get(0).getColor().getR(), this.values.get(0).getColor().getG(), this.values.get(0).getColor().getB());
            gc.setBackground(color);
            gc.fillRectangle(0, 0, width, height);
            color.dispose();
        } else {
            gc.fillRectangle(0, 0, width, height);
        }
        gc.dispose();
        return image;
    }

    public int getType() {
        return this.type;
    }

    public List<ColorValue> getColorValues() {
        return this.values;
    }

    public ColorValue[] getColorValueArray() {
        return this.values.toArray(new ColorValue[this.values.size()]);
    }

    @Deprecated
    public void addCastorColorValue(ColorValue value) {
        this.values.add(value);
        Collections.sort(this.values, new ColorValueComparator());
    }

    @Deprecated
    public void setCastorType(int type) {
        this.type = type;
    }

    public int hashCode() {
        int hash = 364467;
        for (ColorValue cv : this.values) {
            hash ^= cv.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ColorGradient cg = (ColorGradient)obj;
        if (cg.type != this.type) {
            return false;
        }
        if (this.values.size() != cg.values.size()) {
            return false;
        }
        return this.values.containsAll(cg.values);
    }
}

