/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.simantics.utils.ui.internal.Activator;

public class ErrorLogger {
    public static final boolean ECHO = true;
    private final Plugin plugin;
    private String pluginID;

    public ErrorLogger(Plugin plugin) {
        this.plugin = plugin;
    }

    private String getPluginID() {
        if (this.pluginID == null) {
            this.pluginID = this.plugin.getBundle().getSymbolicName();
        }
        return this.pluginID;
    }

    public void logWarning(String message, Throwable exception) {
        this.log(2, 0, message, exception);
    }

    public void logMessage(String message, Throwable exception) {
        this.log(1, 0, message, exception);
    }

    public void logError(String message, Throwable exception) {
        if (exception == null) {
            exception = new RuntimeException();
        }
        this.log(4, 0, message, exception);
    }

    public void log(int severity, int code, String message, Throwable exception) {
        Status status = new Status(severity, this.getPluginID(), code, message, exception);
        this.log((IStatus)status);
    }

    public void log(IStatus status) {
        this.plugin.getLog().log(status);
    }

    public static ErrorLogger getDefault() {
        return Activator.getDefault().getErrorLogger();
    }

    public static void defaultLogError(String message, Throwable exception) {
        ErrorLogger.getDefault().logError(message, exception);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    public static void defaultLogError(Throwable exception) {
        ErrorLogger.getDefault().logError(ErrorLogger.getUIFriendErrorMessage(exception), exception);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    public static void defaultLogWarning(String message, Throwable exception) {
        ErrorLogger.getDefault().logWarning(message, exception);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    public static void defaultLogWarning(Throwable exception) {
        ErrorLogger.getDefault().logWarning(ErrorLogger.getUIFriendErrorMessage(exception), exception);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    public static void defaultLog(IStatus status) {
        ErrorLogger.getDefault().log(status);
        System.out.println(status);
    }

    public static String getUIFriendErrorMessageVerbose(Throwable e) {
        String result = "";
        Throwable pe = null;
        while (e != null && pe != e) {
            result = String.valueOf(result) + e.getClass().getName() + ": " + e.getMessage() + "\n";
            pe = e;
            e = e.getCause();
        }
        return result;
    }

    public static String getUIFriendErrorMessage(Throwable e) {
        String result = "";
        Throwable pe = null;
        while (e != null && pe != e) {
            result = String.valueOf(result) + e.getMessage() + "\n";
            pe = e;
            e = e.getCause();
        }
        return result;
    }
}

