/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * Created on 13.10.2005
 * @author Toni Kalajainen 
 */
package org.simantics.utils.ui.workbench.dialogs;

import java.util.List;
import java.util.Map;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.ListDialog;
import org.simantics.utils.ui.jface.StringListLabelProvider;
import org.simantics.utils.ui.workbench.ui.TableColumnSorter;



/**
 * PropertyDialog is a dialog window popup for properties (key, value pairs)
 *
 */
public class PropertyDialog extends ListDialog {

    public final static String KEY_COLUMN_NAME = "Key";
    public final static String VALUE_COLUMN_NAME = "Value";
    
    protected List<String[]>data;
    protected StringListLabelProvider labelProvider;
    
    public PropertyDialog(Shell parent) {
        super(parent);
        
        this.setContentProvider(new IStructuredContentProvider() {
            public Object[] getElements(Object inputElement) {
                List<?> lines = (List<?>) inputElement;
                return lines.toArray(new String[0][0]);
            }
            public void dispose() {
            }
            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    public int columnNameToColumn(String name) {
        if (name.equals(KEY_COLUMN_NAME)) return 0;
        if (name.equals(VALUE_COLUMN_NAME)) return 1;
        return -1;
    }
    
    @Override
    protected Control createDialogArea(Composite container) {
        Control composite = super.createDialogArea(container);
        TableViewer viewer = getTableViewer();
        Table table = viewer.getTable();
        
        //viewer.setUseHashlookup(true);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        
        
        
        final TableColumn tableColumn = new TableColumn(table, table.getStyle(), 0);
        tableColumn.setWidth(100);
        tableColumn.setText(KEY_COLUMN_NAME);

        final TableColumn tableColumn_2 = new TableColumn(table, table.getStyle(), 1);
        tableColumn_2.setWidth(190);
        tableColumn_2.setText(VALUE_COLUMN_NAME);
        
        // Dialog area is created when dialog.open is called
        // which is after input has been set
        // Therefore there columns have not been created at the time
        // of setting input object before columns have been set.
        // Re-setting input forces to read columns
        viewer.setInput( getTableViewer().getInput() );
        viewer.setColumnProperties(new String[] {KEY_COLUMN_NAME, VALUE_COLUMN_NAME});

        TableColumnSorter.attachTableColumnSorter( viewer );

        return composite;
    }
    
    public void setInput(String lines[][]) {
        labelProvider = new StringListLabelProvider(lines);
        this.setLabelProvider( labelProvider );
        data = labelProvider.getData();
        super.setInput(data);
    }
    
    @Override
    protected int getTableStyle()
    {
        return SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER | SWT.FULL_SELECTION; 
    }
    
    public void setInput(Map<String, String> properties) {
        String lines[][] = new String[properties.size()][];
        int i = 0;
        for (String key : properties.keySet()) {
            String line[] = new String[] {key, properties.get(key)};
            lines[i++] = line;
        }
        setInput(lines);
    }
}


