package org.simantics.utils.ui.wizard;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.simantics.utils.ui.widgets.FileOrDirectorySelectionWidget;
import org.simantics.utils.ui.widgets.FileSelectionListener;
import org.simantics.utils.ui.widgets.FileSelectionWidget;


public class FileSelectionPage extends WizardPage implements FileSelectionListener{
	
	FileSelectionWidget fileSelectionWidget;
	Composite composite;
	String[] filterExtensions = new String[]{"*.*"};
	String[] filterNames = new String[]{"All files"};
	int style = SWT.OPEN;

	public FileSelectionPage() {
		this("Select a file",null);
	}
	
	@Override
	public void createControl(Composite parent) {
		composite = new Composite(parent,SWT.NONE);
		composite.setLayout(new GridLayout(1,false));
		fileSelectionWidget = new FileSelectionWidget(composite, getGroupName(), style);
		fileSelectionWidget.setFilterNames(filterNames);
		fileSelectionWidget.setFilterExtensions(filterExtensions);
		fileSelectionWidget.addListener(this);
		setControl(composite);
		setPageComplete(false);
	}
	
	protected String getGroupName() {
		return "File:";
	}
	
	public FileSelectionPage(String title, ImageDescriptor image) {
		this("FileSelection",title,image);
	}
	
	public FileSelectionPage(String pageName,String title, ImageDescriptor image) {
		super(pageName,title,image);
	}
	
	public String[] getFilterExtensions() {
		return filterExtensions;
	}
	
	public String[] getFilterNames() {
		return filterNames;
	}
	
	public void setFilterExtensions(String[] filterExtensions) {
		this.filterExtensions = filterExtensions;
	}
	
	public void setFilterNames(String[] filterNames) {
		this.filterNames = filterNames;
	}
	
	public int getStyle() {
		return style;
	}
	
	public void setStyle(int style) {
		this.style = style;
	}
	
	public String[] getFilename() {
		return fileSelectionWidget.getFilename();
	}
	
	@Override
	public void fileSelected(FileOrDirectorySelectionWidget source,	String[] filename) {
		setPageComplete(filename != null && filename.length > 0);
	}

}
