package org.simantics.utils.ui.widgets;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class FileSelectionWidget extends FileOrDirectorySelectionWidget {

	
	String[] filterExtensions = new String[]{"*.*"};
	String[] filterNames = new String[]{"All files"};
	int style = SWT.OPEN;
	
	public FileSelectionWidget(Composite parent, String name, int style) {
		super(parent, name, style&~(SWT.OPEN|SWT.CLOSE));
		this.style = style & (SWT.OPEN|SWT.CLOSE|SWT.MULTI);
	}

	@Override
	protected String[] openDialog() {
		FileDialog dialog = new FileDialog(getShell(),style);
		dialog.setFilterExtensions(getFilterExtensions());
		dialog.setFilterNames(getFilterNames());
		String filename = dialog.open();
		if (filename == null)
			return null;
		String path = dialog.getFilterPath();
		String names[] = dialog.getFileNames();
		String fullpath[] = new String[names.length];
		for (int i = 0; i < names.length; i++) {
			fullpath[i] = path + File.separator + names[i];
		}
		return fullpath;
	}

	@Override
	protected boolean isValid(File file) {
		boolean accept = file.exists() && file.canRead();
		return accept;
	}
	
	public String[] getFilterExtensions() {
		return filterExtensions;
	}
	
	public String[] getFilterNames() {
		return filterNames;
	}
	
	public void setFilterExtensions(String[] filterExtensions) {
		this.filterExtensions = filterExtensions;
	}
	
	public void setFilterNames(String[] filterNames) {
		this.filterNames = filterNames;
	}
	

}
