/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * Created on 29.12.2005
 * 
 */
package org.simantics.utils.ui.validators;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.jface.dialogs.IInputValidator;

/**
 * URL Validator
 * 
 * @author Toni Kalajainen
 */
public class URLValidator implements IInputValidator {

    private final String supportedProtocols[];
    
    public URLValidator() { 
        supportedProtocols = null;
    }

    public URLValidator(String... supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }
    
    public String isValid(String newText) {
        try {
            URL u = new URL(newText);
            if (supportedProtocols==null)
                return null;
            for (String p : supportedProtocols)
                if (p.equals(u.getProtocol()))
                    return null;
            return u.getProtocol()+":// is not supported.";            
        } catch (MalformedURLException e) {
            return e.getMessage();
        }
    }

}

