/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.gfx;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;

/**
 * ImageCache caches SWT images and does clean dispose.<br>
 * Based on "eclipse - building commercial-quality plug-ins" book's chapter
 * 7.7's example.<br>
 * 
 * @author Marko Luukkainen
 * 
 * @deprecated Please avoid using this class if at all possible. From a resource
 *             management point-of-view this class does not fit well into a
 *             dynamic OSGi component world. Instead, use JFace
 *             {@link ResourceManager} and particularly
 *             {@link LocalResourceManager}. You can create one in your local
 *             context (a view, editor, bundle activator, etc.) with
 *             <code>new LocalResourceManager(JFaceResources.getResources())</code>
 *             . Remember to dispose your LocalResourceManager when its owner is
 *             disposed. Images can be loaded using
 *             {@link LocalResourceManager#createImage(ImageDescriptor)}.
 * 
 */
public class ImageCache {

    /** A singleton cache instance */
    private static final ImageCache                      imageCache = new ImageCache();

    /** Descriptor to image mapping */
    private final ConcurrentMap<ImageDescriptor, Image>  images     = new ConcurrentHashMap<ImageDescriptor, Image>();

    private final ConcurrentMap<ImageDescriptor, Object> locks      = new ConcurrentHashMap<ImageDescriptor, Object>();

    /**
     * Retrieves and caches the specified image.
     * 
     * @param imageDescriptor the ImageDescriptor of the Image
     * @return Image valid image or <code>null</code>if the image could not be
     *         created
     */
    public Image getImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null)
            return null;

        Image image = images.get(imageDescriptor);
        if (image != null)
            return image;

        Object newLock = new Object();
        Object loadLock = locks.putIfAbsent(imageDescriptor, newLock);
        if (loadLock == null)
            loadLock = newLock;

        // Localized locking, don't lock the whole class while actually loading the image.
        synchronized (loadLock) {
            image = images.get(imageDescriptor);
            if (image == null) {
                boolean returnError = false;
                image = imageDescriptor.createImage(returnError);
                if (image != null) {
                    images.put(imageDescriptor, image);
                }
            }
        }

        locks.remove(imageDescriptor, loadLock);

        return image;
    }

    public void dispose() {
        // Do not synchronize while disposing image resources
        Image[] imgs = null;
        synchronized (images) {
            imgs = images.values().toArray(new Image[images.size()]);
            images.clear();
        }
        locks.clear();

        for (Image img : imgs) {
            img.dispose();
        }
    }

    public static ImageCache getInstance() {
        return imageCache;
    }

}
