/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.color;


/**
 * 
 * 
 * @author Marko Luukkainen
 *
 */
public class ColorValue {
    private Color color;
    private double value;
    
    @Deprecated
    public ColorValue() {
        
    }
    
    public ColorValue(Color color, double value) {
        this.color = color;
        this.value = value;
    }
    
    public Color getColor() {
        return color;
    }
    
    public double getValue() {
        return value;
    }
    
    public void _setValue(double value) {
        this.value = value;
    }
    
    @Override
    public int hashCode() {        
        return color.hashCode() ^ new Double(value).hashCode();
    }
    
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ColorValue))
            return false;
        ColorValue cv = (ColorValue) obj;
        if (cv.value != value) return false;
        if (!cv.color.equals(color)) return false;
        return true;
    }
    
}
