/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.utils.threads;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;


public class ExecutorWorker {
	
	private static ExecutorWorker instance;
	
	static class DelayedExecution implements Comparable<DelayedExecution> {
		Executable executable;
		long executionTime;
		@Override
		public int compareTo(DelayedExecution o) {
			if (o.executionTime<executionTime) return -1;
			if (o.executionTime>executionTime) return 1;
			return 0;
		}
	}

	public static ExecutorWorker getInstance()
	{
		if (instance == null)
			instance = new ExecutorWorker();
		return instance;
	}
	
	ExecutorWorker() {		
	}	

	ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(1);
	
	public synchronized ScheduledFuture<Object> timerExec(final Executable executable, int delay)
	{
		Callable<Object> c = new Callable<Object>() {
			@Override
			public Object call() throws Exception {
                // FIXME: executable.runnable gets called twice!
				ThreadUtils.asyncExec(executable.threadAccess, executable.runnable);
				//executable.runnable.run();
				return null;
			}
		};		
		return pool.schedule(c, delay, TimeUnit.MILLISECONDS);
	}

}
