package org.simantics.utils.strings;

import java.util.Arrays;

import org.junit.Test;


public class TestAlphanumComparator {

    String[] test = {
            "20X Radonius Prime",
            "Xiph Xlater 10000",
            "40X Radonius",
            "20X Radonius",
            "Xiph Xlater 5000",
            "Allegia 6R Clasteron",
            "200X Radonius",
            "10X Radonius",
            "Allegia 50B Clasteron",
            "Allegia 50 Clasteron",
            "30X Radonius",
            "Allegia 51 Clasteron",
            "Alpha 2A",
            "1000X Radonius Maximus",
            "Alpha 2A-8000",
            "Allegia 500 Clasteron",
            "Alpha 2A-900",
            "Callisto Morphamax 600",
            "Alpha 2",
            "Callisto Morphamax",
            "Callisto Morphamax 500",
            "Xiph Xlater 58",
            "Callisto Morphamax 6000 SE",
            "Xiph Xlater 500",
            "Alpha 100",
            "Xiph Xlater 5",
            "Callisto Morphamax 6000 SE2",
            "Callisto Morphamax 7000",
            "Callisto Morphamax 700",
            "Xiph Xlater 40",
            "Xiph Xlater 50",
            "Callisto Morphamax 5000",
            "Alpha 200",
            "Xiph Xlater 300",
            "Xiph Xlater 2000",
    };

    String[] expected = {
            "10X Radonius",
            "20X Radonius",
            "20X Radonius Prime",
            "30X Radonius",
            "40X Radonius",
            "200X Radonius",
            "1000X Radonius Maximus",
            "Allegia 6R Clasteron",
            "Allegia 50 Clasteron",
            "Allegia 50B Clasteron",
            "Allegia 51 Clasteron",
            "Allegia 500 Clasteron",
            "Alpha 2",
            "Alpha 2A",
            "Alpha 2A-900",
            "Alpha 2A-8000",
            "Alpha 100",
            "Alpha 200",
            "Callisto Morphamax",
            "Callisto Morphamax 500",
            "Callisto Morphamax 600",
            "Callisto Morphamax 700",
            "Callisto Morphamax 5000",
            "Callisto Morphamax 6000 SE",
            "Callisto Morphamax 6000 SE2",
            "Callisto Morphamax 7000",
            "Xiph Xlater 5",
            "Xiph Xlater 40",
            "Xiph Xlater 50",
            "Xiph Xlater 58",
            "Xiph Xlater 300",
            "Xiph Xlater 500",
            "Xiph Xlater 2000",
            "Xiph Xlater 5000",
            "Xiph Xlater 10000",
    };

    @Test
    public void testCaseSensitiveSort() {
        Arrays.sort(test, AlphanumComparator.COMPARATOR);
        for (int i = 0; i < test.length; ++i) {
            if (!test[i].equals(expected[i])) {
                throw new RuntimeException("Sorting did not match expected result:\n  result: " + Arrays.toString(test) + "\n  expected: " + Arrays.toString(expected));
            }
        }
    }

    String[] test2 = {
            "AlleGia 50 clAsTeron",
            "ALLEgia 500 ClastERON",
            "AlleGia 51 Clasteron",
            "Allegia 6R CLASTERON",
            "Allegia 50B Clasteron",
    };

    String[] expected2 = {
            "Allegia 6R CLASTERON",
            "AlleGia 50 clAsTeron",
            "Allegia 50B Clasteron",
            "AlleGia 51 Clasteron",
            "ALLEgia 500 ClastERON",
    };

    @Test
    public void testCaseInsensitiveSort() {
        Arrays.sort(test2, AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
        for (int i = 0; i < test2.length; ++i) {
            if (!test2[i].equals(expected2[i])) {
                throw new RuntimeException("Sorting did not match expected result:\n  result: " + Arrays.toString(test2) + "\n  expected: " + Arrays.toString(expected2));
            }
        }
    }

}
