/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.collections;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.utils.datastructures.Pair;

public final class CollectionUtils {
    public static <T> boolean checkedAdd(Collection<T> toBeAdded, Collection<T> addTo) {
        assert (addTo != null);
        if (toBeAdded == null) {
            return false;
        }
        return addTo.addAll(toBeAdded);
    }

    public static int sizeAll(Collection<?> ... collections) {
        int size = 0;
        Collection<?>[] collectionArray = collections;
        int n = collections.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<?> c = collectionArray[n2];
            size += c.size();
            ++n2;
        }
        return size;
    }

    public static <T> Collection<T> join(Collection<T> ... collections) {
        int size = CollectionUtils.sizeAll(collections);
        ArrayList<T> result = new ArrayList<T>(size);
        Collection<T>[] collectionArray = collections;
        int n = collections.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<T> c = collectionArray[n2];
            result.addAll(c);
            ++n2;
        }
        return result;
    }

    public static <T> Set<T> join(Set<T> ... collections) {
        int size = CollectionUtils.sizeAll(collections);
        HashSet<T> result = new HashSet<T>(size);
        Set<T>[] setArray = collections;
        int n = collections.length;
        int n2 = 0;
        while (n2 < n) {
            Set<T> c = setArray[n2];
            result.addAll(c);
            ++n2;
        }
        return result;
    }

    public static <T> Collection<T> join(Collection<T> first, Collection<T> second) {
        int size = first.size();
        ArrayList<T> result = new ArrayList<T>(size += second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    public static <K> Collection<Pair<K, Integer>> valueSortedEntries(TObjectIntHashMap<K> map) {
        ArrayList<Pair<K, Integer>> result = new ArrayList<Pair<K, Integer>>();
        for (Object key : map.keySet()) {
            result.add(new Pair(key, map.get(key)));
        }
        Collections.sort(result, new PairSecondComparator());
        return result;
    }

    public static <K, V extends Comparable<V>> List<Pair<K, V>> valueSortedEntries(Map<K, V> map) {
        ArrayList<Pair<K, V>> result = new ArrayList<Pair<K, V>>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.add(new Pair<K, Comparable>(entry.getKey(), (Comparable)entry.getValue()));
        }
        Collections.sort(result, new PairSecondComparator());
        return result;
    }

    public static <K extends Comparable<K>, V> List<V> sortedBy(List<K> keys, List<V> values) {
        ArrayList<Pair<V, Comparable>> work = new ArrayList<Pair<V, Comparable>>();
        int i = 0;
        while (i < keys.size()) {
            work.add(Pair.make(values.get(i), (Comparable)keys.get(i)));
            ++i;
        }
        Collections.sort(work, new PairSecondComparator());
        ArrayList result = new ArrayList();
        for (Pair pair : work) {
            result.add(pair.first);
        }
        return result;
    }

    public static <K extends Comparable<K>, V> Collection<V> sortByFirst(List<Pair<K, V>> collection) {
        Collections.sort(collection, new PairFirstComparator());
        ArrayList values = new ArrayList();
        for (Pair<K, V> pair : collection) {
            values.add(pair.second);
        }
        return values;
    }

    public static <T> Set<T> join(Set<T> first, Set<T> second) {
        int size = first.size();
        HashSet<T> result = new HashSet<T>(size += second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    public static void main(String[] args) {
        Set<String> c1 = Collections.singleton("FOO");
        Set<String> c2 = Collections.singleton("BAR");
        Set<String> c3 = Collections.singleton("BAZ");
        Collections.singleton("FOO");
        CollectionUtils.join(new Collection[]{c1, c2, c3});
        CollectionUtils.join(c1, c2);
        Set<String> s1 = Collections.singleton("FOO");
        Set<String> s2 = Collections.singleton("BAR");
        Set<String> s3 = Collections.singleton("BAZ");
        Set<String> s4 = Collections.singleton("FOO");
        CollectionUtils.join(s1, s2, s3);
        CollectionUtils.join(s1, s2);
        CollectionUtils.join(s1, s4);
    }

    public static <T> void toggle(Set<T> src, Set<T> toggleSet) {
        for (T i : toggleSet) {
            if (src.contains(i)) {
                src.remove(i);
                continue;
            }
            src.add(i);
        }
    }

    public static <T> List<T> toList(T ... objs) {
        ArrayList<T> result = new ArrayList<T>(objs.length);
        T[] TArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            result.add(o);
            ++n2;
        }
        return result;
    }

    public static <T> Set<T> toSet(T ... objs) {
        THashSet result = new THashSet(objs.length);
        T[] TArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            result.add(o);
            ++n2;
        }
        result.compact();
        return result;
    }

    public static void unique(List<?> list) {
        int c = list.size();
        int i = c - 1;
        while (i > 0) {
            Object o = list.get(i);
            int index = list.indexOf(o);
            if (index >= 0) {
                list.remove(index);
                --c;
                --i;
                continue;
            }
            --i;
        }
    }

    public static <T> T element(Collection<T> collection, int n) {
        if (collection instanceof List) {
            return (T)((List)collection).get(n);
        }
        if (n >= collection.size()) {
            throw new IllegalArgumentException();
        }
        Iterator<T> it = collection.iterator();
        int i = 0;
        while (i < n - 1) {
            it.next();
            ++i;
        }
        return it.next();
    }

    public static String toString(Collection<?> collection, String separator) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (Object o : collection) {
            if (index++ > 0) {
                sb.append(separator);
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    public static String toString(Object[] array, String separator) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (index++ > 0) {
                sb.append(separator);
            }
            sb.append(o.toString());
            ++n2;
        }
        return sb.toString();
    }

    static class PairFirstComparator<K extends Comparable<K>>
    implements Comparator<Pair<K, ?>> {
        PairFirstComparator() {
        }

        @Override
        public int compare(Pair<K, ?> o1, Pair<K, ?> o2) {
            return ((Comparable)o1.first).compareTo((Comparable)o2.first);
        }
    }

    static class PairSecondComparator<V extends Comparable<V>>
    implements Comparator<Pair<?, V>> {
        PairSecondComparator() {
        }

        @Override
        public int compare(Pair<?, V> o1, Pair<?, V> o2) {
            return ((Comparable)o1.second).compareTo((Comparable)o2.second);
        }
    }
}

