/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

public final class Triple<T1, T2, T3> {
    public final T1 first;
    public final T2 second;
    public final T3 third;
    private final int hash;

    public static <T1, T2, T3> Triple<T1, T2, T3> make(T1 t1, T2 t2, T3 t3) {
        return new Triple<T1, T2, T3>(t1, t2, t3);
    }

    public Triple(T1 first, T2 second, T3 third) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.hash = this.makeHash();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Triple other = (Triple)obj;
        if (!(other.first == this.first || other.first != null && other.first.equals(this.first))) {
            return false;
        }
        if (!(other.second == this.second || other.second != null && other.second.equals(this.second))) {
            return false;
        }
        return other.third == this.third || other.third != null && other.third.equals(this.third);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "<" + this.first + ", " + this.second + ", " + this.third + ">";
    }

    private int makeHash() {
        return (this.first == null ? 0 : this.first.hashCode()) + (this.second == null ? 0 : this.second.hashCode()) * 31 + (this.third == null ? 0 : this.third.hashCode()) * 41;
    }
}

