/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.simantics.utils.datastructures.Segment;

public class SegmentSet
implements Iterable<Segment> {
    public static final SegmentSet NONE = new SegmentSet();
    List<Segment> list = new ArrayList<Segment>();

    public static SegmentSet of(double ... times) {
        if (times == null || (times.length & 1) == 1) {
            throw new IllegalArgumentException();
        }
        SegmentSet result = new SegmentSet();
        int i = 0;
        while (i < times.length / 2) {
            result.add(Segment.of(times[i * 2], times[i * 2 + 1]));
            ++i;
        }
        return result;
    }

    public SegmentSet() {
    }

    public SegmentSet(SegmentSet copyFrom) {
        this.list.addAll(copyFrom.list);
    }

    public SegmentSet(Collection<Segment> list) {
        for (Segment r : list) {
            this.add(r);
        }
    }

    public SegmentSet(Segment ... segments) {
        Segment[] segmentArray = Segment.union(segments);
        int n = segmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Segment r = segmentArray[n2];
            this.list.add(r);
            ++n2;
        }
    }

    public boolean add(Segment ... segments) {
        boolean result = false;
        Segment[] segmentArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment r = segmentArray[n2];
            result |= this.add(r);
            ++n2;
        }
        return result;
    }

    public boolean add(SegmentSet set) {
        boolean result = false;
        for (Segment r : set.list) {
            result |= this.add(r);
        }
        return result;
    }

    int indexOf(double value) {
        int i = 0;
        while (i < this.list.size()) {
            Segment r = this.list.get(i);
            if (r.contains(value)) {
                return i;
            }
            if (r.getStart() >= value) {
                return -i - 1;
            }
            ++i;
        }
        return -this.list.size() - 1;
    }

    public Segment getSegmentOf(double value) {
        int index = this.indexOf(value);
        if (index < 0) {
            return null;
        }
        return this.list.get(index);
    }

    public boolean add(Segment range) {
        int startIndex = this.indexOf(range.getStart());
        int endIndex = this.indexOf(range.getEnd());
        if (startIndex >= 0 && startIndex == endIndex) {
            return false;
        }
        if (startIndex < 0 && startIndex == endIndex) {
            this.list.add(-startIndex - 1, range);
            return true;
        }
        double start = range.getStart();
        double end = range.getEnd();
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        } else {
            start = this.list.get(startIndex).getStart();
        }
        if (endIndex < 0) {
            endIndex = -endIndex - 2;
        } else {
            end = this.list.get(endIndex).getEnd();
        }
        int segmentsToRemove = endIndex - startIndex;
        int j = 0;
        while (j < segmentsToRemove) {
            this.list.remove(startIndex);
            ++j;
        }
        if (start != range.getStart() || end != range.getEnd()) {
            range = new Segment(start, end);
        }
        this.list.set(startIndex, range);
        return true;
    }

    public boolean remove(Segment ... ranges) {
        boolean result = false;
        Segment[] segmentArray = ranges;
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            Segment r = segmentArray[n2];
            result |= this.remove(r);
            ++n2;
        }
        return result;
    }

    public boolean remove(SegmentSet set) {
        boolean result = false;
        for (Segment r : set.list) {
            result |= this.remove(r);
        }
        return result;
    }

    public boolean remove(Segment range) {
        Segment s;
        int startIndex = this.indexOf(range.getStart());
        int endIndex = this.indexOf(range.getEnd());
        if (startIndex < 0 && startIndex == endIndex) {
            return false;
        }
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if (endIndex < 0) {
            endIndex = -endIndex - 2;
        }
        if (range.getStart() > this.list.get(startIndex).getStart()) {
            s = this.list.get(startIndex);
            Segment newS = new Segment(s.getStart(), range.getStart());
            this.list.set(startIndex, newS);
            ++startIndex;
            if (s.getEnd() > range.getEnd()) {
                newS = new Segment(range.getEnd(), s.getEnd());
                this.list.add(startIndex, newS);
                ++startIndex;
            }
        }
        if (range.getEnd() < this.list.get(endIndex).getEnd()) {
            s = this.list.get(endIndex);
            s = new Segment(range.getEnd(), s.getEnd());
            this.list.set(endIndex, s);
            --endIndex;
        }
        while (startIndex <= endIndex && range.contains(this.list.get(startIndex))) {
            this.list.remove(startIndex);
            --endIndex;
        }
        return true;
    }

    public void clip(Segment segment) {
        this.remove(new Segment(-1.7976931348623157E308, segment.getStart()));
        this.remove(new Segment(segment.getEnd(), Double.MAX_VALUE));
    }

    public boolean intersects(SegmentSet set) {
        for (Segment s : set.list) {
            if (!this.intersects(s)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Segment s) {
        for (Segment localS : this.list) {
            if (!localS.intersects(s)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Segment s) {
        for (Segment localS : this.list) {
            if (!localS.contains(s)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(double value) {
        return this.indexOf(value) >= 0;
    }

    public Segment getBoundaries() {
        if (this.list.isEmpty()) {
            return null;
        }
        double start = this.list.get(0).getStart();
        double end = this.list.get(this.list.size() - 1).getEnd();
        return new Segment(start, end);
    }

    public Double getLowerBound() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get(0).getStart();
    }

    public Double getUpperBound() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get(this.list.size() - 1).getEnd();
    }

    public Segment[] toArray() {
        return this.list.toArray(new Segment[this.list.size()]);
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.list.iterator();
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public SegmentSet clone() {
        return new SegmentSet(this);
    }
}

