/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.Collection;
import java.util.Iterator;

public class Max2Collection<T>
implements Collection<T> {
    public T first;
    public T second;

    public Max2Collection() {
    }

    public Max2Collection(T first, T second) {
        this.first = first;
        this.second = second;
    }

    public Max2Collection(T first) {
        this.first = first;
    }

    public final T get(int i) {
        if (i == 0) {
            return this.first;
        }
        if (i == 1) {
            return this.second;
        }
        throw new IndexOutOfBoundsException();
    }

    public final T getOther(T el) {
        if (this.first != el) {
            return this.first;
        }
        return this.second;
    }

    @Override
    public final boolean add(T el) {
        if (this.first == null) {
            this.first = el;
        } else if (this.second == null) {
            this.second = el;
        } else {
            throw new CollectionIsFullException();
        }
        return true;
    }

    @Override
    public final boolean remove(Object el) {
        if (this.first == el) {
            this.first = this.second;
            this.second = null;
            return true;
        }
        if (this.second == el) {
            this.second = null;
            return true;
        }
        return false;
    }

    public final void setFirstElement(T el) {
        if (this.second == el) {
            this.second = this.first;
            this.first = el;
        }
    }

    public final void setSecondElement(T el) {
        if (this.first == el) {
            this.first = this.second;
            this.second = el;
        }
    }

    @Override
    public final int size() {
        if (this.first == null) {
            return 0;
        }
        if (this.second == null) {
            return 1;
        }
        return 2;
    }

    @Override
    public final boolean isEmpty() {
        return this.first == null;
    }

    public final boolean isFull() {
        return this.second != null;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T o : c) {
            this.add(o);
        }
        return !c.isEmpty();
    }

    @Override
    public void clear() {
        this.first = null;
        this.second = null;
    }

    @Override
    public boolean contains(Object o) {
        return this.first == o || this.second == o;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for (Object o : c) {
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        if (this.first == null) {
            return new Object[0];
        }
        if (this.second == null) {
            return new Object[]{this.first};
        }
        return new Object[]{this.first, this.second};
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    static class CollectionIsFullException
    extends RuntimeException {
        private static final long serialVersionUID = 8693601196559590064L;

        CollectionIsFullException() {
        }
    }
}

