/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.utils.datastructures.hints;


/**
 * IHintStack is a layered stack of hint contexts.  
 * Each hint context has a priority. 
 * Hint set in higher priority context overrides all lower priority hints of 
 * the same key.
 * 
 * Hint set in a hint context does not become effective if there 
 * exists another hint of the same key in a higher priority context. 
 * 
 * If the higher priority context or its hint is removed, the next lower level hint
 * becomes effective.
 * 
 * getHint() method is global. It returns the highest priority value for the key.
 * It does not return the hint set for a specific context, instead it returns the hint
 * set in the highest priority context.  
 */
public interface IHintStack extends IHintObservable {

	void addHintContext(IHintContext hints, int priority);
	
	boolean removeHintContext(IHintContext hints);
	
	/**
	 * Returns a wrapper hint context whose read operations originate from the stack, and
	 * write operations to the a local stack (argument ctx)
	 * 
     * @param ctx the hint context to write into
     * @return write-localized hint context based on this hint stack
	 */
	IHintContext createStackRead(final IHintContext ctx);	
	
}
