/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

import java.util.ListIterator;

public class ListIteratorAdapter<Domain, Range, I extends ListIterator<Domain>> 
    extends IteratorAdapter<Domain,Range,I> 
    implements ListIterator<Range> {

    public ListIteratorAdapter(Converter<Domain,Range> converter, I iterator) {
        super(converter, iterator);
    }
    
    @Override
    public void add(Range e) {
        iterator.add(converter.convertFrom(e));        
    }

    @Override
    public boolean hasPrevious() {
        return iterator.hasPrevious();
    }

    @Override
    public int nextIndex() {
        return iterator.nextIndex(); 
    }

    @Override
    public Range previous() {
        return converter.convertTo(iterator.previous());
    }

    @Override
    public int previousIndex() {
        return iterator.previousIndex();
    }

    @Override
    public void set(Range e) {
        iterator.set(converter.convertFrom(e));
    }

}
