/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.action;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.Resource;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * @author Tuukka Lehtonen
 */
public class PerformDefaultAction extends Action {

    private Control  control;
    private Resource component;

    public PerformDefaultAction(String name, Control control, Resource component) {
        super(name);
        this.control = control;
        this.component = component;
    }

    @Override
    public void run() {
        final String perspectiveId = WorkbenchUtils.getCurrentPerspectiveId();
        Shell shell = null;
        if (control != null) {
            shell = control.getShell();
        } else {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
            if (window != null)
                shell = window.getShell();
        }
        SimanticsUI.getSession().asyncRequest(new ChooseActionRequest(shell, control, component, perspectiveId));
    }

}