/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.project.IProject;
import org.simantics.ui.SimanticsUI;

/**
 * @author Tuukka Lehtonen
 */
public class ToolTipRequest implements Read<String> {

    private final String               editorId;

    private final IResourceEditorInput input;

    public ToolTipRequest(String editorId, IResourceEditorInput input) {
        this.editorId = editorId;
        this.input = input;
    }

    @Override
    public String perform(ReadGraph graph) throws DatabaseException {
        Resource r = input.getResource();

        IProject p = SimanticsUI.peekProject();
        if (p != null) {
            IEditorNamingService ems = EditorNaming.getNamingService(graph, r); 
            if (ems instanceof IEditorNamingService2)
                return ((IEditorNamingService2) ems).getToolTipText(graph, editorId, input);
        }

        return graph.syncRequest(new TitleRequest(editorId, input));
    }

}