/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.simantics.db.Session;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.ui.SimanticsUI;

/**
 * @author Tuukka Lehtonen
 */
public abstract class SharedHeaderResourceFormEditor extends SharedHeaderFormEditor implements IResourceEditorPart {

    protected boolean               disposed = false;
    protected ResourceEditorSupport support;

    /**
     * Override to define your own input resource editor input validator that
     * the view uses by default in {@link #init(IEditorSite, IEditorInput)}.
     * 
     * @return
     */
    protected ParametrizedRead<IResourceEditorInput, Boolean> getInputValidator() {
        return null;
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        init(site, input, getInputValidator());
    }

    protected void init(IEditorSite site, IEditorInput input,
            ParametrizedRead<IResourceEditorInput, Boolean> inputValidator) throws PartInitException {
        if (!(input instanceof IResourceEditorInput))
            throw new PartInitException("Invalid input: must be IResourceEditorInput");
        super.init(site, input);

        support = new ResourceEditorSupport(this, inputValidator);

        // Set initial part name according to the name given by IEditorInput
        setPartName(getEditorInput().getName());

        Session session = SimanticsUI.peekSession();
        if (session != null) {
            session.asyncRequest(
                    new TitleRequest(site.getId(), getResourceInput()),
                    new TitleUpdater(site.getShell().getDisplay(), this::setPartName, () -> disposed));
        }
    }

    @Override
    public void dispose() {
        disposed = true;
        support.dispose();
        super.dispose();
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
    }

    @Override
    public final void doSaveAs() {
    }

    @Override
    public final boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public IResourceEditorInput getResourceInput() {
        return (IResourceEditorInput) getEditorInput();
    }

    protected Session getSession() {
        return support.getSession();
    }

}
