/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IEditorInput;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 * 
 * @see IResourceEditorInput2
 * @see ResourceEditorInput
 * @see ResourceEditorInput2
 */
public interface IResourceEditorInput extends IEditorInput {

    /**
     * @param adapter not needed anymore since 1.6, may be <code>null</code>
     */
    void init(IAdaptable adapter) throws DatabaseException;

    /**
     * Release any strong references to resources held by this editor input.
     * Does nothing when called multiple times.
     */
    void dispose();

    /**
     * @return the same as getResourceArray().get(0) or <code>null</code> if
     *         resource does not exist, i.e. getResourceArray returns an empty
     *         resource array
     */
    Resource getResource();

    /**
     * @return <code>null</code> if resource does not exist
     */
    ResourceArray getResourceArray();

    /**
     * For checking the existence of the resource input from the given graph.
     * 
     * @param g
     * @return
     */
    boolean exists(ReadGraph g) throws DatabaseException;

    /**
     * Needs to be called on every update by the related editor part to keep the
     * cached data coherent with the graph model.
     * 
     * @param g
     */
    void update(ReadGraph g) throws DatabaseException;

}
