package org.simantics.ui.selection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

public class VariableWorkbenchSelectionElement implements WorkbenchSelectionElement {
	
	final private Variable variable;
	
	public VariableWorkbenchSelectionElement(Variable variable) {
		this.variable = variable;
	}
	
    @SuppressWarnings("unchecked")
    @Override
    public <T> T getContent(WorkbenchSelectionContentType<T> contentType) {
    	if(contentType instanceof AnyResource) {
    		AnyResource type = (AnyResource)contentType;
            try {
                return (T) type.processor.sync(new UnaryRead<Variable, Resource>(variable) {
                    @Override
                    public Resource perform(ReadGraph graph) throws DatabaseException {
                    	return parameter.getRepresents(graph);
                    }
                });
            } catch (DatabaseException e) {
                Logger.defaultLogError(e);
            }
    	}
    	else if(contentType instanceof AnyVariable) {
    		return (T)variable;
        } 
        return null;
    }
	
	@Override
	public int hashCode() {
		return variable.hashCode();
	}
	
	@Override
	public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof VariableWorkbenchSelectionElement))
            return false;
        VariableWorkbenchSelectionElement vwse = (VariableWorkbenchSelectionElement)object;
        return variable.equals(vwse.variable);
	}
    

}
