/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.fonts;

import java.awt.Font;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;

/**
 * @author Antti Villberg
 */
public class Fonts {

    public static java.awt.Font awt(FontDescriptor descriptor) {
        return new Font(descriptor.getFamily(), descriptor.getStyle(), descriptor.getSize());
    }
    
    public static org.simantics.datatypes.literal.Font fromAWT(Font f) {
    	return new org.simantics.datatypes.literal.Font(f.getFamily(), f.getSize(), fromAwtStyle(f.getStyle()));
    }

    private static boolean hasMask(int test, int mask) {
        return (test & mask) == mask;
    }

    public static String fromSwtStyle(int swtStyle) {
        if(hasMask(swtStyle, SWT.BOLD|SWT.ITALIC)) return "BoldItalic";
        else if (hasMask(swtStyle, SWT.BOLD)) return "Bold";
        else if (hasMask(swtStyle, SWT.ITALIC)) return "Italic";
        return "Normal";
    }

    public static String fromAwtStyle(int awtStyle) {
        if(hasMask(awtStyle, Font.BOLD|Font.ITALIC)) return "BoldItalic";
        else if (hasMask(awtStyle, Font.BOLD)) return "Bold";
        else if (hasMask(awtStyle, Font.ITALIC)) return "Italic";
        return "Normal";
    }

    public static int swtStyle(String text) {
    	if("Normal".equals(text)) return SWT.NORMAL;
    	else if ("Bold".equals(text)) return SWT.BOLD;
    	else if ("Italic".equals(text)) return SWT.ITALIC;
    	else if ("BoldItalic".equals(text)) return SWT.BOLD|SWT.ITALIC;
    	else throw new RuntimeException("Illegal style '" + text + "'");
    }
    
    public static int awtStyle(String text) {
    	if("Normal".equals(text)) return 0;
    	else if ("Bold".equals(text)) return Font.BOLD;
    	else if ("Italic".equals(text)) return Font.ITALIC;
    	else if ("BoldItalic".equals(text)) return Font.BOLD|Font.ITALIC;
    	else throw new RuntimeException("Illegal style '" + text + "'");
    }

    /**
     * Returns SWT Font instance. Be aware that this is a native resource and
     * must be disposed of properly.
     * 
     * @param device
     * @param font
     * @return
     * @see #swt(org.simantics.datatypes.literal.Font)
     */
    public static org.eclipse.swt.graphics.Font swt(Device device, org.simantics.datatypes.literal.Font font) {
        return new org.eclipse.swt.graphics.Font(device, font.family, font.height, swtStyle(font.style));
    }

    /**
     * Returns JFace FontDescriptor instance.
     * 
     * @param font
     * @return FontDescriptor for specified font
     */
    public static org.eclipse.jface.resource.FontDescriptor swt(org.simantics.datatypes.literal.Font font) {
        return org.eclipse.jface.resource.FontDescriptor.createFrom(font.family, font.height, swtStyle(font.style));
    }

    /**
     * Returns SWT FontData instance.
     * 
     * @param font
     * @return FontData for specified font
     */
    public static FontData swtFontData(org.simantics.datatypes.literal.Font font) {
        return new FontData(font.family, font.height, swtStyle(font.style));
    }

    public static java.awt.Font awt(org.simantics.datatypes.literal.Font font) {
        return new java.awt.Font(font.family, awtStyle(font.style), font.height);
    }

}
