package org.simantics.ui.dnd;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MultiTransferable implements Transferable, ClipboardOwner {
	
	Map<DataFlavor, Transferable> transferables = new HashMap<>();
	
	public MultiTransferable(Transferable ... tr) {
		for(Transferable t : tr) {
			for(DataFlavor f : t.getTransferDataFlavors()) {
				transferables.put(f, t);
			}
		}
	}

	public MultiTransferable(Collection<Transferable> tr) {
		for(Transferable t : tr) {
			for(DataFlavor f : t.getTransferDataFlavors()) {
				transferables.put(f, t);
			}
		}
	}

	@Override
	public void lostOwnership(Clipboard arg0, Transferable arg1) {
		for(Transferable t : transferables.values())
			if(t instanceof ClipboardOwner) ((ClipboardOwner) t).lostOwnership(arg0, arg1);
	}

	@Override
	public Object getTransferData(DataFlavor arg0) throws UnsupportedFlavorException, IOException {
		Transferable t = transferables.get(arg0);
		if(t == null) return t;
		return t.getTransferData(arg0);
	}

	@Override
	public DataFlavor[] getTransferDataFlavors() {
		return transferables.keySet().toArray(new DataFlavor[transferables.size()]);
	}

	@Override
	public boolean isDataFlavorSupported(DataFlavor arg0) {
		return transferables.containsKey(arg0);
	}

	@Override
	public String toString() {
		return "MultiTransferable " + transferables.toString();
	}

}
