/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend.impl;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryItem;
import org.simantics.history.HistoryManager;
import org.simantics.history.ItemManager;
import org.simantics.history.util.Stream;
import org.simantics.history.util.ValueBand;
import org.simantics.history.util.subscription.SamplingFormat;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.trend.configuration.LineQuality;
import org.simantics.trend.configuration.Scale;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.impl.TrendLayout;
import org.simantics.trend.impl.TrendNode;
import org.simantics.trend.impl.VertRuler;
import org.simantics.trend.util.KvikDeviationBuilder;

public class ItemNode
extends G2DNode
implements TrendLayout {
    private static final long serialVersionUID = -4741446944761752871L;
    public static final AlphaComposite composite = AlphaComposite.getInstance(3, 0.61f);
    public TrendItem item;
    VertRuler ruler;
    TrendNode trendNode;
    Bean[] historyItems;
    Bean[] renderableItems = new Bean[0];
    Bean minmaxItem;
    double from = Double.NaN;
    double end = Double.NaN;
    double min = 0.0;
    double max = 1.0;
    BasicStroke stroke;
    Color color;
    Stream openStream;
    StreamAccessor openStreamAccessor;
    Bean openStreamItem;
    Logger log = Logger.getLogger(this.getClass().getName());
    boolean disabled = false;
    Point2D.Double pt = new Point2D.Double();
    Point2D.Double pt2 = new Point2D.Double();
    KvikDeviationBuilder dev = new KvikDeviationBuilder();
    Path2D.Double line = new Path2D.Double();
    double currentX;
    double currentY;
    double minX;
    double maxX;

    public void setTrendItem(TrendItem ti, ItemManager items) {
        if (this.openStream != null) {
            this.openStream.close();
            this.openStream = null;
            this.openStreamAccessor = null;
            this.openStreamItem = null;
        }
        this.item = ti;
        this.minmaxItem = null;
        this.renderableItems = new HistoryItem[0];
        this.disabled = true;
        if (ti == null) {
            return;
        }
        try {
            List trendItems = items.search("groupId", (Object)ti.groupId, "groupItemId", (Object)ti.groupItemId, "variableId", (Object)ti.variableId);
            this.historyItems = trendItems.toArray(new Bean[trendItems.size()]);
            Arrays.sort(this.historyItems, SamplingFormat.INTERVAL_COMPARATOR);
            TreeSet<Bean> streamFormats = new TreeSet<Bean>(SamplingFormat.INTERVAL_COMPARATOR);
            for (Bean item : trendItems) {
                boolean isMinMaxFormat;
                SamplingFormat format = new SamplingFormat();
                format.readAvailableFields(item);
                RecordType rt = (RecordType)format.format;
                Boolean enabled = (Boolean)item.getField("enabled");
                if (!enabled.booleanValue()) continue;
                boolean bl = isMinMaxFormat = format.interval == Double.MAX_VALUE && format.deadband == Double.MAX_VALUE && rt.getComponentIndex2("min") >= 0 && rt.getComponentIndex2("max") >= 0;
                if (isMinMaxFormat) {
                    this.minmaxItem = item;
                    continue;
                }
                streamFormats.add(item);
            }
            if (streamFormats.isEmpty()) {
                return;
            }
            this.renderableItems = streamFormats.toArray(new Bean[streamFormats.size()]);
            this.disabled = false;
        }
        catch (BindingException e) {
            throw new RuntimeException(e);
        }
    }

    public void draw(Graphics2D g, int phase, boolean bold) {
        Object old;
        Object newQuality;
        boolean devAndLine = this.item.drawMode == TrendItem.DrawMode.DeviationAndAverage || this.item.drawMode == TrendItem.DrawMode.DeviationAndLine || this.item.drawMode == TrendItem.DrawMode.DeviationAndSample;
        Object object = newQuality = this.getTrendNode().printing || this.getTrendNode().quality.lineQuality == LineQuality.Antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        if (phase == 1) {
            g.setColor(this.color);
            if (!this.dev.isEmpty()) {
                old = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, newQuality);
                if (this.item.renderer == TrendItem.Renderer.Binary) {
                    this.dev.drawRectangles(g);
                }
                if (this.item.renderer == TrendItem.Renderer.Analog) {
                    if (devAndLine) {
                        Composite c = g.getComposite();
                        g.setComposite(composite);
                        this.dev.drawRectangles(g);
                        g.setComposite(c);
                    } else if (this.item.drawMode == TrendItem.DrawMode.Deviation) {
                        this.dev.drawRectangles(g);
                    }
                }
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
            }
        }
        if (phase == 2) {
            g.setColor(this.color);
            old = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, newQuality);
            g.draw(this.line);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
        }
    }

    private boolean validSample(ValueBand band) throws HistoryException {
        if (band.getTimeDouble() > 1.0E50) {
            return false;
        }
        return !(band.getTimeDouble() > band.getEndTimeDouble());
    }

    void moveTo(double x, double y) {
        this.line.moveTo(x, y);
        this.currentX = x;
        this.currentY = y;
    }

    void lineToOrdered(double x, double y) {
        double ny;
        if (x < this.minX) {
            return;
        }
        if (this.currentX > this.maxX) {
            return;
        }
        if (this.currentX < this.minX) {
            ny = this.currentY + (y - this.currentY) * (this.minX - this.currentX) / (x - this.currentX);
            this.line.moveTo(this.minX, ny);
            this.currentX = this.minX;
            this.currentY = ny;
        }
        if (x > this.maxX) {
            ny = this.currentY + (y - this.currentY) * (this.maxX - this.currentX) / (x - this.currentX);
            this.line.lineTo(this.maxX, ny);
            this.line.moveTo(x, y);
        } else {
            this.line.lineTo(x, y);
        }
    }

    void lineTo(double x, double y) {
        if (this.currentX <= x) {
            this.lineToOrdered(x, y);
        } else {
            this.line.moveTo(x, y);
        }
        this.currentX = x;
        this.currentY = y;
    }

    public void prepareLine(double from, double end, double pixelsPerSecond, AffineTransform at) throws HistoryException, AccessorException {
        boolean devAndLine = false;
        boolean deviationEnabled = false;
        this.dev.reset();
        this.line.reset();
        Stream s = this.openStream(pixelsPerSecond);
        if (s == null) {
            return;
        }
        ValueBand vb = new ValueBand((Binding)s.sampleBinding, s.sampleBinding.createDefaultUnchecked());
        boolean hasDeviation = vb.hasMin() && vb.hasMax();
        boolean drawDeviation = hasDeviation & deviationEnabled;
        Datatype valueType = vb.getValueBinding().type();
        s.reset();
        if (!(valueType instanceof BooleanType) && !(valueType instanceof NumberType)) {
            return;
        }
        int start = s.binarySearch((Binding)Bindings.DOUBLE, (Object)from);
        int count = s.count();
        if (start < 0) {
            start = -2 - start;
        }
        if (start < 0) {
            start = 0;
        }
        boolean lineNotAttached = true;
        boolean devNotAttached = true;
        this.currentX = Double.NaN;
        this.currentY = Double.NaN;
        this.pt.setLocation(from, 0.0);
        at.transform(this.pt, this.pt);
        this.minX = this.pt.x;
        this.pt.setLocation(end, 0.0);
        at.transform(this.pt, this.pt);
        this.maxX = this.pt.x;
        s.reset();
        boolean wentOver = false;
        int i = start;
        while (i < count) {
            Byte b;
            boolean noncontinuation;
            s.accessor.get(i, (Binding)s.sampleBinding, vb.getSample());
            if (!this.validSample(vb)) {
                System.err.println("-invalid value band: " + i + "/" + count + ":" + vb);
            } else if (vb.hasQuality() && (noncontinuation = (b = (Byte)vb.getQuality((Binding)Bindings.BYTE)).equals(ValueBand.QUALITY_NOVALUE))) {
                lineNotAttached = true;
                devNotAttached = true;
            } else {
                double y1;
                double t2;
                double t1 = vb.getTimeDouble();
                double d = t2 = vb.hasEndTime() ? vb.getEndTimeDouble() : t1;
                if (this.item.renderer == TrendItem.Renderer.Analog) {
                    if (this.item.drawMode != TrendItem.DrawMode.Deviation || !hasDeviation) {
                        double yy = Double.NaN;
                        boolean flat = false;
                        if (this.trendNode != null && this.trendNode.drawSamples) {
                            yy = vb.getValueDouble();
                            flat = true;
                        } else {
                            yy = vb.getValueDouble();
                        }
                        if (Double.isNaN(yy)) {
                            lineNotAttached = true;
                        } else {
                            this.pt.setLocation(t1, yy);
                            at.transform(this.pt, this.pt);
                            this.pt2.setLocation(t2, yy);
                            at.transform(this.pt2, this.pt2);
                            double x1 = this.pt.x;
                            y1 = this.pt.y;
                            double x2 = this.pt2.x;
                            double y2 = this.pt2.y;
                            if (lineNotAttached) {
                                this.moveTo(x1, y1);
                            } else if (flat) {
                                this.lineTo(x1, this.currentY);
                                this.lineTo(x1, y1);
                            } else {
                                this.lineTo(x1, y1);
                            }
                            this.lineTo(x2, y2);
                            lineNotAttached = false;
                        }
                    }
                    if (drawDeviation) {
                        boolean tooWide;
                        double min = vb.getMinDouble();
                        double max = vb.getMaxDouble();
                        this.pt.setLocation(t1, min);
                        at.transform(this.pt, this.pt);
                        this.pt2.setLocation(t2, max);
                        at.transform(this.pt2, this.pt2);
                        double x1 = this.pt.x;
                        double x2 = this.pt2.x;
                        double y12 = this.pt.y;
                        double y2 = this.pt2.y;
                        double width = x2 - x1;
                        boolean bl = tooWide = devAndLine && width > 2.0;
                        if (Double.isNaN(min) || Double.isNaN(max) || tooWide || width <= 0.0 || y12 == y2) {
                            devNotAttached = true;
                        } else {
                            if (devNotAttached) {
                                this.dev.addRectangle(x1, x2, y12, y2);
                            } else {
                                this.dev.extendRectangle(x1);
                                this.dev.addRectangle(x1, x2, y12, y2);
                            }
                            devNotAttached = false;
                        }
                    }
                }
                if (this.item.renderer == TrendItem.Renderer.Binary) {
                    byte value = 0;
                    value = vb.getValueBinding() instanceof BooleanBinding ? ((Boolean)vb.getValue((Binding)Bindings.BOOLEAN) != false ? (byte)0 : 1) : (vb.getValueBinding() instanceof ByteBinding ? (Byte)vb.getValue((Binding)Bindings.BYTE) : (vb.hasMax() ? ((Byte)vb.getMax((Binding)Bindings.BYTE)).byteValue() : ((Byte)vb.getValue((Binding)Bindings.BYTE)).byteValue()));
                    this.pt.setLocation(t1, value == 1 ? BINARY[1] : BINARY[0]);
                    at.transform(this.pt, this.pt);
                    this.pt2.setLocation(t2, BINARY[2]);
                    at.transform(this.pt2, this.pt2);
                    double x1 = this.pt.x;
                    double x2 = this.pt2.x;
                    y1 = this.pt.y;
                    double y2 = this.pt2.y;
                    this.dev.extendRectangle(x1);
                    this.dev.addRectangle(x1, x2, y1, y2);
                    devNotAttached = false;
                }
                if (wentOver) break;
                if (t2 >= end) {
                    wentOver = true;
                }
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean readMinMaxFromEnd() {
        if (this.disabled) {
            return false;
        }
        HistoryManager history = this.getTrendNode().historian;
        boolean hasVariable = !this.item.variableId.isEmpty() && !this.item.groupItemId.isEmpty() && !this.item.groupId.isEmpty();
        boolean canReadMinMax = this.minmaxItem != null;
        boolean manualScale = this.item.scale instanceof Scale.Manual;
        if (!hasVariable) {
            this.min = 0.0;
            this.max = 1.0;
            this.from = Double.NaN;
            this.end = Double.NaN;
            return false;
        }
        try {
            if (canReadMinMax && !manualScale) {
                StreamAccessor sa;
                block25: {
                    block24: {
                        String id = (String)this.minmaxItem.getFieldUnchecked("id");
                        sa = history.openStream(id, "r");
                        if (sa == null) {
                            this.min = 0.0;
                            this.max = 1.0;
                            this.from = Double.NaN;
                            this.end = Double.NaN;
                            return false;
                        }
                        if (sa.size() != 0) break block24;
                        try {
                            sa.close();
                        }
                        catch (AccessorException accessorException) {}
                        return false;
                    }
                    try {
                        this.min = Double.MAX_VALUE;
                        this.max = -1.7976931348623157E308;
                        this.from = Double.MAX_VALUE;
                        this.end = -1.7976931348623157E308;
                        int i = 0;
                        while (i < sa.size()) {
                            Object sample;
                            Binding binding = Bindings.getBinding((Datatype)sa.type().componentType());
                            ValueBand vb = new ValueBand(binding, sample = sa.get(i, binding));
                            if (!vb.isNullValue() && !vb.isNanSample()) {
                                this.min = Math.min(this.min, vb.getMinDouble());
                                this.max = Math.max(this.max, vb.getMaxDouble());
                            }
                            if (!vb.isNullValue()) {
                                this.from = Math.min(this.from, vb.getTimeDouble());
                                this.end = Math.max(this.end, vb.getEndTimeDouble());
                            }
                            ++i;
                        }
                        if (this.min == Double.MAX_VALUE || this.max == -1.7976931348623157E308) {
                            this.min = 0.0;
                            this.max = 1.0;
                        }
                        if (this.from != Double.MAX_VALUE && this.end != -1.7976931348623157E308) break block25;
                        this.from = 0.0;
                        this.end = 100.0;
                    }
                    catch (Throwable throwable) {
                        try {
                            sa.close();
                        }
                        catch (AccessorException accessorException) {}
                        throw throwable;
                    }
                }
                try {
                    sa.close();
                }
                catch (AccessorException accessorException) {}
                return true;
            }
            if (manualScale) {
                Scale.Manual ms = (Scale.Manual)this.item.scale;
                this.min = ms.min;
                this.max = ms.max;
            }
            if (this.openStreamAccessor == null) {
                this.openStream(1.0);
            }
            if (this.openStreamAccessor != null) {
                StreamAccessor sa = this.openStreamAccessor;
                sa.reset();
                int count = sa.size();
                if (count > 0) {
                    Binding binding = Bindings.getBinding((Datatype)sa.type().componentType());
                    Object sample = sa.get(0, binding);
                    ValueBand vb = new ValueBand(binding, sample);
                    this.from = vb.getTimeDouble();
                    sa.get(count - 1, binding, sample);
                    this.end = vb.hasEndTime() ? vb.getEndTimeDouble() : vb.getTimeDouble();
                }
                return true;
            }
            return false;
        }
        catch (AccessorException e) {
            this.log.log(Level.FINE, e.toString(), e);
            return false;
        }
        catch (HistoryException e) {
            this.log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public void cleanup() {
        this.trendNode = null;
        if (this.openStreamAccessor != null) {
            try {
                this.openStreamAccessor.close();
            }
            catch (AccessorException accessorException) {}
            this.openStreamAccessor = null;
            this.openStreamItem = null;
        }
        super.cleanup();
    }

    Bean getFormat(double pixelsPerSecond) {
        Bean result = null;
        if (this.renderableItems == null) {
            return null;
        }
        Bean[] beanArray = this.renderableItems;
        int n = this.renderableItems.length;
        int n2 = 0;
        while (n2 < n) {
            Bean format = beanArray[n2];
            double interval = 0.0;
            try {
                interval = format.hasField("interval") ? (Double)format.getFieldUnchecked("interval") : 0.0;
            }
            catch (RuntimeBindingException runtimeBindingException) {
            }
            catch (BindingException bindingException) {}
            if (!Double.isNaN(interval) && !(interval <= pixelsPerSecond)) break;
            result = format;
            ++n2;
        }
        if (result == null) {
            result = this.renderableItems.length == 0 ? null : this.renderableItems[0];
        }
        return result;
    }

    public Stream openStream(double pixelsPerSecond) {
        Bean f = this.getFormat(pixelsPerSecond);
        if (f == this.openStreamItem) {
            return this.openStream;
        }
        if (this.openStream != null) {
            this.openStream.close();
            this.openStreamAccessor = null;
            this.openStreamItem = null;
            this.openStream = null;
        }
        if (this.disabled) {
            return null;
        }
        if (f != null) {
            HistoryManager historian = this.getTrendNode().historian;
            try {
                String id = (String)f.getFieldUnchecked("id");
                this.openStreamAccessor = historian.openStream(id, "r");
                if (this.openStreamAccessor != null) {
                    this.openStream = new Stream((ArrayAccessor)this.openStreamAccessor);
                    this.openStreamItem = f;
                } else {
                    this.openStream = null;
                }
            }
            catch (HistoryException e) {
                this.log.log(Level.FINE, e.toString(), e);
            }
        }
        return this.openStream;
    }

    public void render(Graphics2D g2d) {
    }

    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    TrendNode getTrendNode() {
        return (TrendNode)this.getParent();
    }
}

