/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend.configuration;

import org.simantics.databoard.annotations.Identifier;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.util.Bean;
import org.simantics.trend.configuration.Scale;
import org.simantics.utils.strings.AlphanumComparator;

public class TrendItem
extends Bean {
    public int index;
    @Optional
    public String label;
    @Optional
    public String simpleLabel;
    @Optional
    public String variableReference;
    @Identifier
    public String groupId;
    @Identifier
    public String groupItemId;
    @Identifier
    public String variableId;
    public Scale scale;
    public Renderer renderer;
    @Optional
    public String unit;
    public DrawMode drawMode = DrawMode.getDefault();
    public boolean hidden = false;
    @Optional
    public Float customStrokeWidth;
    @Optional
    public float[] customColor;

    public TrendItem() {
    }

    public TrendItem(int index, String label, String subscriptionId, String variableId, Scale scale) {
        this(index, label, subscriptionId, variableId, scale, Renderer.Analog);
    }

    public TrendItem(int index, String label, String subscriptionId, String variableId, Scale scale, Renderer renderer) {
        this.index = index;
        this.label = label;
        this.variableId = variableId;
        this.scale = scale;
        this.renderer = renderer;
        this.groupId = subscriptionId;
        this.groupItemId = variableId;
    }

    public TrendItem(int index, String label, String subscriptionId, String variableId, Scale scale, Renderer renderer, double min, double max) {
        this.index = index;
        this.label = label;
        this.variableId = variableId;
        this.scale = new Scale.Manual(min, max);
        this.renderer = renderer;
        this.groupId = subscriptionId;
        this.groupItemId = variableId;
    }

    public TrendItem(int index, String label, String subscriptionId, String variableId, Scale scale, Renderer renderer, double min, double max, DrawMode drawMode) {
        this.index = index;
        this.label = label;
        this.variableId = variableId;
        this.scale = new Scale.Manual(min, max);
        this.renderer = renderer;
        this.groupId = subscriptionId;
        this.groupItemId = variableId;
        this.drawMode = drawMode;
    }

    public int compareTo(Bean o) {
        String otVid;
        String otGiid;
        String otSid;
        String otLabel2;
        String otLabel1;
        if (!(o instanceof TrendItem)) {
            return 0;
        }
        TrendItem other = (TrendItem)o;
        int c = this.renderer.ordinal() - other.renderer.ordinal();
        if (c != 0) {
            return c;
        }
        c = this.index - other.index;
        if (c != 0) {
            return c;
        }
        String myLabel1 = this.label != null ? this.label : "";
        c = AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)myLabel1, (Object)(otLabel1 = other.label != null ? other.label : ""));
        if (c != 0) {
            return c;
        }
        String myLabel2 = this.simpleLabel != null ? this.simpleLabel : "";
        c = AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)myLabel2, (Object)(otLabel2 = other.simpleLabel != null ? other.simpleLabel : ""));
        if (c != 0) {
            return c;
        }
        String mySid = this.groupId != null ? this.groupId : "";
        c = mySid.compareTo(otSid = other.groupId != null ? other.groupId : "");
        if (c != 0) {
            return c;
        }
        String myGiid = this.groupItemId != null ? this.groupItemId : "";
        c = myGiid.compareTo(otGiid = other.groupItemId != null ? other.groupItemId : "");
        if (c != 0) {
            return c;
        }
        String myVid = this.variableId != null ? this.variableId : "";
        c = myVid.compareTo(otVid = other.variableId != null ? other.variableId : "");
        if (c != 0) {
            return c;
        }
        return c;
    }

    public static enum DrawMode {
        DeviationAndLine,
        DeviationAndAverage,
        DeviationAndSample,
        Average,
        Line,
        Sample,
        Deviation;


        public static DrawMode getDefault() {
            return DeviationAndLine;
        }
    }

    public static enum Renderer {
        Analog,
        Binary;

    }
}

