package org.simantics.tests.modelled.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class TestsResource {
    
    public final Resource SCLMain;
    public final Resource STSSuite;
    public final Resource STSSuite_moduleNameFilter;
    public final Resource STSSuite_moduleNameFilter_Inverse;
    public final Resource STSTest;
    public final Resource STSTest_definition;
    public final Resource STSTest_definition_Inverse;
    public final Resource STSTest_executionPriority;
    public final Resource STSTest_executionPriority_Inverse;
        
    public static class URIs {
        public static final String SCLMain = "http://www.simantics.org/Tests-1.0/SCLMain";
        public static final String STSSuite = "http://www.simantics.org/Tests-1.0/STSSuite";
        public static final String STSSuite_moduleNameFilter = "http://www.simantics.org/Tests-1.0/STSSuite/moduleNameFilter";
        public static final String STSSuite_moduleNameFilter_Inverse = "http://www.simantics.org/Tests-1.0/STSSuite/moduleNameFilter/Inverse";
        public static final String STSTest = "http://www.simantics.org/Tests-1.0/STSTest";
        public static final String STSTest_definition = "http://www.simantics.org/Tests-1.0/STSTest/definition";
        public static final String STSTest_definition_Inverse = "http://www.simantics.org/Tests-1.0/STSTest/definition/Inverse";
        public static final String STSTest_executionPriority = "http://www.simantics.org/Tests-1.0/STSTest/executionPriority";
        public static final String STSTest_executionPriority_Inverse = "http://www.simantics.org/Tests-1.0/STSTest/executionPriority/Inverse";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public TestsResource(ReadGraph graph) {
        SCLMain = getResourceOrNull(graph, URIs.SCLMain);
        STSSuite = getResourceOrNull(graph, URIs.STSSuite);
        STSSuite_moduleNameFilter = getResourceOrNull(graph, URIs.STSSuite_moduleNameFilter);
        STSSuite_moduleNameFilter_Inverse = getResourceOrNull(graph, URIs.STSSuite_moduleNameFilter_Inverse);
        STSTest = getResourceOrNull(graph, URIs.STSTest);
        STSTest_definition = getResourceOrNull(graph, URIs.STSTest_definition);
        STSTest_definition_Inverse = getResourceOrNull(graph, URIs.STSTest_definition_Inverse);
        STSTest_executionPriority = getResourceOrNull(graph, URIs.STSTest_executionPriority);
        STSTest_executionPriority_Inverse = getResourceOrNull(graph, URIs.STSTest_executionPriority_Inverse);
    }
    
    public static TestsResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        TestsResource ret = session.peekService(TestsResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new TestsResource(qc.getIndependentGraph(graph));
            session.registerService(TestsResource.class, ret);
        }
        return ret;
    }
    
    public static TestsResource getInstance(RequestProcessor session) throws DatabaseException {
        TestsResource ret = session.peekService(TestsResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<TestsResource>() {
                public TestsResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new TestsResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(TestsResource.class, ret);
        }
        return ret;
    }
    
}

