/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui.handlers;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.simantics.db.Resource;
import org.simantics.db.ServerReference;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.TeamSupport;
import org.simantics.team.Activator;
import org.simantics.team.Utils;
import org.simantics.team.internal.StagingLauncher;
import org.simantics.team.ui.StageInitWizard;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.handler.AbstractPreferenceHandler;
import org.simantics.utils.FileUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.dialogs.ShowError;

public class SynchroniseAllHandler
extends AbstractPreferenceHandler {
    public SynchroniseAllHandler() {
        super((AbstractUIPlugin)Activator.getDefault());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        File teamFolder;
        File stFolder;
        Session session;
        block3: {
            System.out.println("DEBUG: SynchronizeAllHandler");
            session = SimanticsUI.getSession();
            File wsFolder = new File(Platform.getInstanceLocation().getURL().getFile());
            stFolder = new File(wsFolder, "staging");
            teamFolder = SynchroniseAllHandler.pullAll(session, Utils.getTeamFolder(), stFolder);
            if (teamFolder != null) break block3;
            return null;
        }
        try {
            SynchroniseAllHandler.show(session, teamFolder, stFolder);
        }
        catch (DatabaseException e) {
            ShowError.showError((String)"Staging In.", (String)"Staging failed", (Throwable)e);
        }
        return null;
    }

    static File pullAll(Session session, File teamFolder, File stFolder) throws DatabaseException {
        File dbFolder = new File(stFolder, "db");
        try {
            FileUtils.deleteAll((File)dbFolder);
            File tempFolder = new File(stFolder, "temp");
            FileUtils.deleteAll((File)tempFolder);
            File indexingFolder = new File(stFolder, ".metadata/.plugins/org.simantics.db.indexing");
            FileUtils.deleteAll((File)indexingFolder);
            File procoreFolder = new File(stFolder, "metadata/.plugins/org.simantics.db.procore");
            FileUtils.deleteAll((File)procoreFolder);
        }
        catch (IOException e) {
            throw new DatabaseException("Pull failed.", (Throwable)e);
        }
        if (teamFolder == null || !teamFolder.isDirectory()) {
            StageInitWizard.Data data = new StageInitWizard.Data(stFolder, null);
            data.requireExisting = true;
            if (!StageInitWizard.openInitWizard(data)) {
                Utils.setTeamFolder(null);
                return null;
            }
            teamFolder = data.teamFolder;
            assert (teamFolder != null);
        }
        TeamSupport ts = (TeamSupport)session.getService(TeamSupport.class);
        ts.pull(teamFolder, dbFolder);
        return teamFolder;
    }

    static void show(Session session, File teamFolder, File wsFolder) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            try {
                monitor.beginTask("begin", 1300);
                LifecycleSupport lfs = (LifecycleSupport)session.getService(LifecycleSupport.class);
                ServerReference sref = lfs.getSessionReference().getServerReference();
                String randomAccessId = "target";
                Resource targetLibrary = null;
                StagingLauncher.Config config = new StagingLauncher.Config(session, targetLibrary, wsFolder, teamFolder);
                config.titlePrefix = wsFolder.getName();
                StagingLauncher.StagingResult result = StagingLauncher.launch(config, sref.toString(), randomAccessId);
                if (result.getExitValue() != 0) {
                    String msg = "";
                    if (result.getLogFile().exists()) {
                        byte[] data = FileUtils.readFile((File)result.getLogFile());
                        msg = new String(data, Charset.defaultCharset());
                    }
                    if (msg.isEmpty() || msg.matches(" *")) {
                        msg = "Staging crashed and burned. Contact application support.";
                    }
                    ShowError.showError((String)("Staging failed, errorcode=" + result.getExitValue()), (String)msg, (Throwable)new Exception());
                }
                if (result.getMessageLog() != null) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Staging failed", (String)result.getMessageLog());
                }
            }
            catch (Exception e) {
                ErrorLogger.defaultLogError((Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

