/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.db.exception.DatabaseException;

public class Utils {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    protected static final Charset UTF8 = Charset.forName("UTF-8");

    public static final File getNewFolder(int index, String prefix, String suffix) {
        File toFolder;
        while ((toFolder = new File(String.valueOf(prefix) + index + suffix)).exists()) {
        }
        return toFolder;
    }

    public static final String bytesToStringASCII(byte[] bytes, int offset, int length) throws IOException {
        return Utils.bytesToString(bytes, offset, length, ASCII);
    }

    public static final String bytesToStringUTF8(byte[] bytes, int offset, int length) throws IOException {
        return Utils.bytesToString(bytes, offset, length, UTF8);
    }

    public static final String bytesToString(byte[] bytes, int offset, int length, Charset charset) throws IOException {
        if (bytes == null || offset < 0 || offset > length - 1 || length < 0 || length > bytes.length) {
            return null;
        }
        ByteBuffer bbuf = ByteBuffer.wrap(bytes, offset, length);
        String s = null;
        try {
            CharBuffer cbuf = charset.newDecoder().decode(bbuf);
            s = cbuf.toString();
        }
        catch (CharacterCodingException characterCodingException) {
            bbuf.rewind();
            try {
                CharBuffer cbuf = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(bbuf);
                s = cbuf.toString();
            }
            catch (CharacterCodingException e1) {
                throw new IOException("String conversion error.", e1);
            }
        }
        return s;
    }

    public static final File getTeamFolder() throws DatabaseException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.team.ui");
        String currentTeamFolder = store.getString("CURRENT_TEAM_FOLDER");
        if (!currentTeamFolder.equals("")) {
            return new File(currentTeamFolder);
        }
        String name = System.getProperty("staging.team.folder");
        if (name != null && !name.equals("")) {
            return new File(name);
        }
        String folder = System.getProperty("java.io.tmpdir");
        if (folder == null || folder.equals("")) {
            throw new DatabaseException("Could not get team folder path.");
        }
        return null;
    }

    public static final void setTeamFolder(File teamFolder) throws DatabaseException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.team.ui");
        if (teamFolder == null) {
            store.setValue("CURRENT_TEAM_FOLDER", "");
        } else {
            store.setValue("CURRENT_TEAM_FOLDER", teamFolder.getAbsolutePath());
        }
    }
}

