package org.simantics.team.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * Dialog for chart properties:
 * 
 * Comment: 
 */
public class StageInitDialog extends Dialog {
    public static class Data {
        public String comment;
    }
    Label lName;
    Text tName;
    Data data;
    public StageInitDialog(Shell parentShell, Data data) {
        super(parentShell);
        this.data = data;
        setShellStyle(SWT.RESIZE | SWT.TITLE | SWT.CLOSE | SWT.BORDER);
    }
    @Override
    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite) super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(9).applyTo(c);
        GridDataFactory gd1 = GridDataFactory.fillDefaults().span(1, 1);
        GridDataFactory gd2 = GridDataFactory.fillDefaults().grab(true, false).span(8, 1);
        // Comment:
        lName = new Label(c, 0);
        lName.setText("Comment:");
        gd1.applyTo(lName);
        tName = new Text(c, SWT.BORDER);
        tName.setEnabled(true);
        if (null != data.comment)
            tName.setText(data.comment);
        gd2.applyTo(tName);
        return c;
    }
    @Override
    protected void okPressed() {
        data.comment = tName.getText();
        super.okPressed();
    }
    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Comment");
    }
}
